/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.data;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtcore.block.BlockCasing;
import org.gtreimagined.gtcore.block.BlockSapBag;
import org.gtreimagined.gtcore.blockentity.BlockEntityPlasticBin;
import org.gtreimagined.gtcore.blockentity.BlockEntitySapBag;
import org.gtreimagined.gtcore.blockentity.BlockEntityTrashCan;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtcore.integration.tfc.TFCRubberData;
import org.gtreimagined.gtcore.machine.BarrelMachine;
import org.gtreimagined.gtcore.machine.BookShelfMachine;
import org.gtreimagined.gtcore.machine.ChestMachine;
import org.gtreimagined.gtcore.machine.DrumMachine;
import org.gtreimagined.gtcore.machine.HopperMachine;
import org.gtreimagined.gtcore.machine.LockerMachine;
import org.gtreimagined.gtcore.machine.MassStorageMachine;
import org.gtreimagined.gtcore.machine.MaterialMachine;
import org.gtreimagined.gtcore.machine.WorkbenchMachine;
import org.gtreimagined.gtcore.tree.block.BlockRubberButton;
import org.gtreimagined.gtcore.tree.block.BlockRubberDoor;
import org.gtreimagined.gtcore.tree.block.BlockRubberFence;
import org.gtreimagined.gtcore.tree.block.BlockRubberFenceGate;
import org.gtreimagined.gtcore.tree.block.BlockRubberLeaves;
import org.gtreimagined.gtcore.tree.block.BlockRubberLog;
import org.gtreimagined.gtcore.tree.block.BlockRubberPressurePlate;
import org.gtreimagined.gtcore.tree.block.BlockRubberSapling;
import org.gtreimagined.gtcore.tree.block.BlockRubberSign;
import org.gtreimagined.gtcore.tree.block.BlockRubberSlab;
import org.gtreimagined.gtcore.tree.block.BlockRubberStairs;
import org.gtreimagined.gtcore.tree.block.BlockRubberTrapDoor;
import org.gtreimagined.gtcore.tree.block.BlockRubberWallSign;
import org.gtreimagined.gtcore.tree.block.BlockRubberWood;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class GTCoreBlocks {
    private static final VoxelShape BOOKSHELF_TOP = Shapes.m_83048_((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape BOOKSHELF_BOTTOM = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    private static final VoxelShape BOOKSHELF_Z_SHAPE_CENTER = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0, (double)0.9375);
    public static final VoxelShape BOOKSHELF_Z_SHAPE = Shapes.m_83124_((VoxelShape)BOOKSHELF_Z_SHAPE_CENTER, (VoxelShape[])new VoxelShape[]{BOOKSHELF_TOP, BOOKSHELF_BOTTOM, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)});
    private static final VoxelShape BOOKSHELF_X_SHAPE_CENTER = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0);
    public static final VoxelShape BOOKSHELF_X_SHAPE = Shapes.m_83124_((VoxelShape)BOOKSHELF_X_SHAPE_CENTER, (VoxelShape[])new VoxelShape[]{BOOKSHELF_TOP, BOOKSHELF_BOTTOM, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0625), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0, (double)1.0)});
    public static WoodType RUBBER_WOOD_TYPE = new WoodType("rubber"){};
    public static Block RUBBER_LEAVES;
    public static final BlockRubberLog RUBBER_LOG;
    public static final BlockRubberLog STRIPPED_RUBBER_LOG;
    public static final BlockRubberWood RUBBER_WOOD;
    public static final BlockRubberWood STRIPPED_RUBBER_WOOD;
    public static final BlockBasic RUBBER_PLANKS;
    public static final BlockRubberSign RUBBER_SIGN;
    public static final BlockRubberWallSign RUBBER_WALL_SIGN;
    public static Block RUBBER_SAPLING;
    public static final BlockRubberButton RUBBER_BUTTON;
    public static final BlockRubberPressurePlate RUBBER_PRESSURE_PLATE;
    public static final BlockRubberDoor RUBBER_DOOR;
    public static final BlockRubberTrapDoor RUBBER_TRAPDOOR;
    public static final BlockRubberSlab RUBBER_SLAB;
    public static final BlockRubberStairs RUBBER_STAIRS;
    public static final BlockRubberFence RUBBER_FENCE;
    public static final BlockRubberFenceGate RUBBER_FENCE_GATE;
    public static final BlockSapBag SAP_BAG;
    public static final BlockEntityType<?> SAP_BAG_BLOCK_ENTITY;
    public static MaterialMachine WOOD_ITEM_BARREL;
    public static MaterialMachine PLASTIC_STORAGE_BOX;
    @Nullable
    public static MaterialMachine IRONWOOD_ITEM_BARREL;
    public static BasicMachine ENDER_GARBAGE_BIN;
    public static StoneType RED_GRANITE;
    public static StoneType BLACK_GRANITE;
    public static StoneType MARBLE;
    public static StoneType BASALT;
    public static StoneType KOMATIITE;
    public static StoneType LIMESTONE;
    public static StoneType GREEN_SCHIST;
    public static StoneType BLUE_SCHIST;
    public static StoneType KIMBERLITE;
    public static StoneType QUARTZITE;
    public static StoneType SHALE;
    public static StoneType SLATE;
    public static final BlockCasing REINFORCED_GLASS;
    public static final BlockCasing REINFORCED_STONE;
    public static BookShelfMachine OAK_BOOKSHELF;
    public static BookShelfMachine SPRUCE_BOOKSHELF;
    public static BookShelfMachine BIRCH_BOOKSHELF;
    public static BookShelfMachine JUNGLE_BOOKSHELF;
    public static BookShelfMachine ACACIA_BOOKSHELF;
    public static BookShelfMachine DARK_OAK_BOOKSHELF;
    public static BookShelfMachine CRIMSON_BOOKSHELF;
    public static BookShelfMachine WARPED_BOOKSHELF;
    public static BookShelfMachine RUBBER_BOOKSHELF;

    public static Boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public static void init() {
        if (!GTAPI.isModLoaded((String)"tfc")) {
            RUBBER_LEAVES = new BlockRubberLeaves();
            RUBBER_SAPLING = new BlockRubberSapling();
        } else {
            GTCoreBlocks.initTFC();
        }
        GTCoreBlocks.initWoodBookShelves();
        GTAPI.register(BlockEntityType.class, (String)"sap_bag", (String)"gtcore", SAP_BAG_BLOCK_ENTITY);
    }

    private static void initWoodBookShelves() {
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            Function<String, Block> f = s -> RegistryUtils.getBlockFromId((String)"twilightforest", (String)s);
            new BookShelfMachine("towerwood", "twilightforest", new Texture("twilightforest", "block/towerwood"), () -> (Block)f.apply("towerwood"));
            new BookShelfMachine("twilight_oak", "twilightforest", new Texture("twilightforest", "block/wood/planks_twilight_oak_0"), () -> (Block)f.apply("twilight_oak_planks"));
            new BookShelfMachine("canopy", "twilightforest", new Texture("twilightforest", "block/wood/planks_canopy_0"), () -> (Block)f.apply("canopy_planks"));
            new BookShelfMachine("mangrove", "twilightforest", new Texture("twilightforest", "block/wood/planks_mangrove_0"), () -> (Block)f.apply("mangrove_planks"));
            new BookShelfMachine("darkwood", "twilightforest", new Texture("twilightforest", "block/wood/planks_darkwood_0"), () -> (Block)f.apply("dark_planks"));
            new BookShelfMachine("timewood", "twilightforest", new Texture("twilightforest", "block/wood/planks_time_0"), () -> (Block)f.apply("time_planks"));
            new BookShelfMachine("transwood", "twilightforest", new Texture("twilightforest", "block/wood/planks_trans_0"), () -> (Block)f.apply("transformation_planks"));
            new BookShelfMachine("minewood", "twilightforest", new Texture("twilightforest", "block/wood/planks_mine_0"), () -> (Block)f.apply("mining_planks"));
            new BookShelfMachine("sortingwood", "twilightforest", new Texture("twilightforest", "block/wood/planks_sort_0"), () -> (Block)f.apply("sorting_planks"));
        }
    }

    public static void initItemBarrels() {
        WOOD_ITEM_BARREL = (MaterialMachine)((MaterialMachine)new MassStorageMachine("gtcore", GTLibMaterials.Wood, "item_storage", 5000).addFlags(new String[]{"gui"})).setToolTag(GTTools.AXE.getToolType());
        PLASTIC_STORAGE_BOX = (MaterialMachine)((MaterialMachine)((MaterialMachine)new MassStorageMachine("gtcore", GTCoreMaterials.Plastic, "storage_box", 128).setTile((type, pos, state) -> new BlockEntityPlasticBin((MassStorageMachine)((Object)type), pos, state))).addTooltipInfo((blockMachine, itemStack, blockGetter, list, tooltipFlag) -> {
            list.remove(1);
            list.add(1, Utils.translatable((String)"machine.mass_storage.capacity", (Object[])new Object[]{"Variable"}));
        })).setToolTag(GTTools.AXE.getToolType());
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            IRONWOOD_ITEM_BARREL = (MaterialMachine)((MaterialMachine)new MassStorageMachine("gtcore", GTCoreMaterials.Ironwood, "item_storage", 10000).addFlags(new String[]{"gui"})).setToolTag(GTTools.AXE.getToolType());
        }
    }

    private static void initTFC() {
        TFCRubberData.init();
    }

    public static DrumMachine createDrum(Material material, int maxCapacity) {
        DrumMachine machine = (DrumMachine)((Object)GTAPI.get(DrumMachine.class, (String)(material.getId() + "_drum"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new DrumMachine("gtcore", material, maxCapacity);
    }

    public static MassStorageMachine createMassStorage(Material material, int capacity) {
        MassStorageMachine machine = (MassStorageMachine)((Object)GTAPI.get(MassStorageMachine.class, (String)(material.getId() + "_mass_storage"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new MassStorageMachine("gtcore", material, "mass_storage", capacity);
    }

    public static WorkbenchMachine createWorkbench(Material material, boolean charge) {
        WorkbenchMachine machine = (WorkbenchMachine)((Object)GTAPI.get(WorkbenchMachine.class, (String)(material.getId() + (charge ? "_charging" : "") + "_workbench"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new WorkbenchMachine("gtcore", material, charge);
    }

    public static LockerMachine createLocker(Material material, boolean charge) {
        LockerMachine machine = (LockerMachine)((Object)GTAPI.get(LockerMachine.class, (String)(material.getId() + (charge ? "_charging" : "") + "_locker"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new LockerMachine("gtcore", material, charge);
    }

    public static ChestMachine createChest(Material material) {
        return GTCoreBlocks.createChest(material, true);
    }

    public static ChestMachine createChest(Material material, boolean addSlots) {
        ChestMachine machine = (ChestMachine)((Object)GTAPI.get(ChestMachine.class, (String)(material.getId() + "_chest"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new ChestMachine("gtcore", material, addSlots);
    }

    public static BarrelMachine createBarrel(Material material) {
        return GTCoreBlocks.createBarrel(material, true);
    }

    public static BarrelMachine createBarrel(Material material, boolean addSlots) {
        BarrelMachine machine = (BarrelMachine)((Object)GTAPI.get(BarrelMachine.class, (String)(material.getId() + "_barrel"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new BarrelMachine("gtcore", material, addSlots);
    }

    public static HopperMachine createHopper(Material material, int slots) {
        HopperMachine machine = (HopperMachine)((Object)GTAPI.get(HopperMachine.class, (String)(material.getId() + "_hopper"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new HopperMachine("gtcore", material, slots);
    }

    public static BookShelfMachine createBookShelf(Material material) {
        BookShelfMachine machine = (BookShelfMachine)((Object)GTAPI.get(BookShelfMachine.class, (String)(material.getId() + "_bookshelf"), (String)"gtcore"));
        if (machine != null) {
            return machine;
        }
        return new BookShelfMachine(material);
    }

    static {
        RUBBER_LOG = new BlockRubberLog("gtcore", "rubber_log");
        STRIPPED_RUBBER_LOG = new BlockRubberLog("gtcore", "stripped_rubber_log");
        RUBBER_WOOD = new BlockRubberWood("gtcore", "rubber_wood");
        STRIPPED_RUBBER_WOOD = new BlockRubberWood("gtcore", "stripped_rubber_wood");
        RUBBER_PLANKS = new BlockBasic("gtcore", "rubber_planks", BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)){

            public Texture[] getTextures() {
                return new Texture[]{new Texture(this.domain, "block/tree/rubber_planks")};
            }
        };
        RUBBER_SIGN = new BlockRubberSign();
        RUBBER_WALL_SIGN = new BlockRubberWallSign();
        RUBBER_BUTTON = new BlockRubberButton();
        RUBBER_PRESSURE_PLATE = new BlockRubberPressurePlate();
        RUBBER_DOOR = new BlockRubberDoor();
        RUBBER_TRAPDOOR = new BlockRubberTrapDoor();
        RUBBER_SLAB = new BlockRubberSlab();
        RUBBER_STAIRS = new BlockRubberStairs();
        RUBBER_FENCE = new BlockRubberFence();
        RUBBER_FENCE_GATE = new BlockRubberFenceGate();
        SAP_BAG = new BlockSapBag();
        SAP_BAG_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(BlockEntitySapBag::new, (Block[])new Block[]{SAP_BAG}).m_58966_(null);
        IRONWOOD_ITEM_BARREL = null;
        ENDER_GARBAGE_BIN = (BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)((BasicMachine)new BasicMachine("gtcore", "ender_garbage_bin").setBaseTexture(new Texture("gtcore", "block/machine/base/ender_garbage_bin"))).setTiers(new Tier[]{Tier.NONE})).setCustomModel()).setItemModelParent(new ResourceLocation("gtcore", "block/ender_garbage_bin_base"))).addFlags(new String[]{"item", "fluid", "unculled", "gui"})).removeFlags(new String[]{"coverable", "eu"})).setAllowsFrontIO()).setNoOutputCover()).setTile(BlockEntityTrashCan::new);
        RED_GRANITE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "red_granite", GTCoreMaterials.RedGranite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(4.5f, 60.0f).setHarvestLevel(3);
        BLACK_GRANITE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "black_granite", GTCoreMaterials.BlackGranite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(4.5f, 60.0f).setHarvestLevel(3);
        MARBLE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "marble", GTCoreMaterials.Marble, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        BASALT = (StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "basalt", GTCoreMaterials.Basalt, "block/stone/", SoundType.f_56718_, true).setHardnessAndResistance(1.25f, 4.2f));
        KOMATIITE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "komatiite", GTCoreMaterials.Komatiite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(3.0f, 30.0f).setHarvestLevel(2);
        LIMESTONE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "limestone", GTCoreMaterials.Limestone, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        GREEN_SCHIST = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "green_schist", GTCoreMaterials.GreenSchist, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        BLUE_SCHIST = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "blue_schist", GTCoreMaterials.BlueSchist, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        KIMBERLITE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "kimberlite", GTCoreMaterials.Kimberlite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(3.0f, 30.0f).setHarvestLevel(2);
        QUARTZITE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "quartzite", GTCoreMaterials.Quartzite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        SHALE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "shale", GTCoreMaterials.Shale, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        SLATE = ((StoneType)GTAPI.register(StoneType.class, (IGTObject)new CobbleStoneType("gtcore", "slate", GTCoreMaterials.Slate, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
        REINFORCED_GLASS = new BlockCasing("gtcore", "reinforced_glass", BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76275_).m_60913_(15.0f, 150.0f).m_60918_(SoundType.f_56744_).m_60999_().m_60955_().m_60922_((blockState, blockGetter, blockPos, object) -> false).m_60924_(GTCoreBlocks::isntSolid).m_60960_(GTCoreBlocks::isntSolid).m_60971_(GTCoreBlocks::isntSolid));
        REINFORCED_STONE = new BlockCasing("gtcore", "reinforced_stone", BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76278_).m_60913_(80.0f, 150.0f).m_60918_(SoundType.f_56742_).m_60999_());
        OAK_BOOKSHELF = new BookShelfMachine("oak", new Texture("block/oak_planks"), () -> Blocks.f_50705_);
        SPRUCE_BOOKSHELF = new BookShelfMachine("spruce", new Texture("block/spruce_planks"), () -> Blocks.f_50741_);
        BIRCH_BOOKSHELF = new BookShelfMachine("birch", new Texture("block/birch_planks"), () -> Blocks.f_50742_);
        JUNGLE_BOOKSHELF = new BookShelfMachine("jungle", new Texture("block/jungle_planks"), () -> Blocks.f_50743_);
        ACACIA_BOOKSHELF = new BookShelfMachine("acacia", new Texture("block/acacia_planks"), () -> Blocks.f_50744_);
        DARK_OAK_BOOKSHELF = new BookShelfMachine("dark_oak", new Texture("block/dark_oak_planks"), () -> Blocks.f_50745_);
        CRIMSON_BOOKSHELF = new BookShelfMachine("crimson", new Texture("block/crimson_planks"), () -> Blocks.f_50655_);
        WARPED_BOOKSHELF = new BookShelfMachine("warped", new Texture("block/warped_planks"), () -> Blocks.f_50656_);
        RUBBER_BOOKSHELF = new BookShelfMachine("rubber", new Texture("gtcore", "block/tree/rubber_planks"), () -> RUBBER_PLANKS);
    }
}

