/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.cover;

import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtcore.blockentity.BlockEntityRedstoneWire;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverSelectorTag
extends BaseCover {
    final int mode;

    public CoverSelectorTag(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory, int mode) {
        super(source, tier, side, factory);
        this.mode = mode;
    }

    public void onFirstTick() {
        BlockEntity blockEntity = this.source().getTile();
        if (blockEntity instanceof BlockEntityRedstoneWire) {
            BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)blockEntity;
            wire.setMode(this.mode);
        }
    }

    public void onPlace() {
        BlockEntity blockEntity = this.source().getTile();
        if (blockEntity instanceof BlockEntityRedstoneWire) {
            BlockEntityRedstoneWire wire = (BlockEntityRedstoneWire)blockEntity;
            wire.setMode(this.mode);
        }
    }

    public void onRemove() {
        BlockEntityRedstoneWire wire;
        super.onRemove();
        BlockEntity blockEntity = this.source().getTile();
        if (blockEntity instanceof BlockEntityRedstoneWire && !(wire = (BlockEntityRedstoneWire)blockEntity).m_58901_()) {
            wire.setMode(0);
        }
    }

    protected String getRenderId() {
        return "selector_tag";
    }

    public void setTextures(BiConsumer<String, Texture> texer) {
        texer.accept("overlay", (Texture)this.factory.getTextures().get(0));
        texer.accept("underlay", (Texture)this.factory.getTextures().get(1));
    }

    public ResourceLocation getModel(String type, Direction dir) {
        Object renderId = type.equals("pipe") ? this.getRenderId() + "_pipe" : this.getRenderId();
        return new ResourceLocation("gtcore:block/cover/" + (String)renderId);
    }
}

