/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.util.CodeUtils;

public class MassStorageRenderer<T extends BlockEntityMassStorage>
implements BlockEntityRenderer<T> {
    private static final Matrix3f FAKE_NORMALS;

    public void render(T tile, float pPartialTicks, PoseStack matrix, MultiBufferSource pBuffer, int light, int overlayLight) {
        if (tile.getMachineState() == MachineState.ACTIVE) {
            return;
        }
        Level level = tile.m_58904_();
        if (level == null || Minecraft.m_91087_().f_91074_ != null && !tile.m_58899_().m_123314_((Vec3i)Minecraft.m_91087_().f_91074_.m_20097_(), 32.0)) {
            return;
        }
        ITrackedHandler display = ((BlockEntityMassStorage)tile).itemHandler.map(i -> i.getHandler(SlotType.DISPLAY)).orElse(null);
        ITrackedHandler storage = ((BlockEntityMassStorage)tile).itemHandler.map(i -> i.getHandler(SlotTypes.UNLIMITED)).orElse(null);
        if (display != null && storage != null) {
            ItemStack stack = display.getStackInSlot(0);
            if (stack.m_41619_()) {
                stack = storage.getStackInSlot(0);
            }
            if (!stack.m_41619_()) {
                Direction facing = tile.getFacing();
                BlockPos coverPos = tile.m_58899_().m_142300_(facing);
                BlockState state = level.m_8055_(coverPos);
                if (state.m_60795_() || !state.m_60815_() || !state.m_60783_((BlockGetter)level, coverPos, facing.m_122424_())) {
                    matrix.m_85836_();
                    matrix.m_85850_().m_85864_().m_8169_(FAKE_NORMALS);
                    switch (facing) {
                        case NORTH: {
                            matrix.m_85837_(0.73, 0.83, -1.0E-4);
                            matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                            break;
                        }
                        case SOUTH: {
                            matrix.m_85837_(0.27, 0.83, 1.0001);
                            break;
                        }
                        case WEST: {
                            matrix.m_85837_(-1.0E-4, 0.83, 0.27);
                            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                            break;
                        }
                        case EAST: {
                            matrix.m_85837_(1.0001, 0.83, 0.73);
                            matrix.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                        }
                    }
                    float scale = 0.03125f;
                    float scaler = 0.9f;
                    matrix.m_85841_(scale * scaler, scale * scaler, 1.0E-4f);
                    matrix.m_85837_(8.0, -16.0, 8.0);
                    matrix.m_85841_(16.0f, 16.0f, 16.0f);
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)tile.m_58899_().m_142300_(facing));
                    Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GUI, light, overlayLight, matrix, pBuffer, CodeUtils.bindInt((long)tile.m_58899_().m_121878_()));
                    matrix.m_85849_();
                }
            }
        }
    }

    static {
        Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);
        NORMAL.m_122278_();
        FAKE_NORMALS = new Matrix3f(new Quaternion(NORMAL, 0.0f, true));
    }
}

