/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtcore.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtcore.blockentity.BlockEntityMassStorage;
import org.gtreimagined.gtcore.data.SlotTypes;
import org.gtreimagined.gtcore.machine.MassStorageMachine;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityPlasticBin
extends BlockEntityMassStorage {
    int maxLimit = 128;

    public BlockEntityPlasticBin(MassStorageMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getMaxLimit() {
        return this.maxLimit;
    }

    @Override
    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        if (type == GTTools.WIRE_CUTTER) {
            ItemStack stored;
            int n = this.maxLimit = player.m_6047_() ? this.maxLimit / 2 : this.maxLimit * 2;
            if (this.maxLimit == 32) {
                this.maxLimit = 1024;
            }
            if (this.maxLimit > 1024) {
                this.maxLimit = 64;
            }
            player.m_6352_((Component)Utils.literal((String)("Max capacity set to:  " + this.maxLimit / 64 + " stacks")), player.m_142081_());
            this.sidedSync(true);
            Utils.damageStack((ItemStack)player.m_21120_(hand), (InteractionHand)hand, (LivingEntity)player);
            ITrackedHandler handler = this.itemHandler.map(i -> i.getHandler(SlotTypes.UNLIMITED)).orElse(null);
            int amountToExtract = handler.getStackInSlot(0).m_41613_() - this.maxLimit;
            if (amountToExtract > 0 && !(stored = handler.getStackInSlot(0)).m_41619_()) {
                if (amountToExtract > stored.m_41741_()) {
                    ItemStack toAdd;
                    for (int toExtract = amountToExtract; toExtract > 0; toExtract -= toAdd.m_41613_()) {
                        toAdd = Utils.ca((int)Math.min(stored.m_41741_(), toExtract), (ItemStack)stored);
                        if (player.m_36356_(toAdd)) continue;
                        player.m_36176_(toAdd, true);
                    }
                } else {
                    ItemStack toAdd = Utils.ca((int)amountToExtract, (ItemStack)stored);
                    if (!player.m_36356_(toAdd)) {
                        player.m_36176_(toAdd, true);
                    }
                }
                handler.extractItem(0, amountToExtract, false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        updateTag.m_128405_("maxLimit", this.maxLimit);
        return updateTag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.maxLimit = tag.m_128451_("maxLimit");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("maxLimit", this.maxLimit);
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> list = super.getInfo(simple);
        list.add("Max Capacity: " + this.maxLimit / 64 + " stacks");
        return list;
    }
}

