/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.vanillaore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.worldgen.OreObject;
import org.gtreimagined.gtlib.worldgen.vanillaore.VanillaVein;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaVeinBuilder {
    @Nullable
    private Material material;
    @Nullable
    private Material secondary;
    @Nullable
    private MaterialTypeBlock<?> materialType;
    @Nullable
    private MaterialTypeBlock<?> secondaryType;
    @Nullable
    private Integer weight;
    @Nullable
    private Integer probability;
    @Nullable
    private Integer maxY;
    @Nullable
    private Integer minY;
    @Nullable
    private Integer size;
    @Nullable
    private Integer plateau;
    @Nullable
    private Float secondaryChance;
    @Nullable
    private Float discardOnExposureChance;
    ResourceLocation id;
    List<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
    List<String> biomes = new ArrayList<String>();
    boolean biomeBlacklist = true;
    boolean triangle = false;
    boolean spawnOnOceanFloor = false;

    public VanillaVeinBuilder(@NotNull ResourceLocation id) {
        this.id = id;
    }

    public final VanillaVein buildMaterial() {
        if (this.id == null) {
            throw new RuntimeException("id required");
        }
        if (this.size == null) {
            throw new RuntimeException("size is required");
        }
        if (this.material == null) {
            throw new RuntimeException("material is required");
        }
        MaterialTypeBlock<MaterialTypeBlock.IOreGetter> materialTypeBlock = this.materialType == null ? GTMaterialTypes.ORE : this.materialType;
        return new VanillaVein(this.id, new OreObject(this.material, materialTypeBlock), new OreObject(this.secondary == null ? Material.NULL : this.secondary, this.secondaryType == null ? materialTypeBlock : this.secondaryType), this.secondaryChance == null ? 0.0f : this.secondaryChance.floatValue(), this.discardOnExposureChance == null ? 0.0f : this.discardOnExposureChance.floatValue(), this.minY != null ? this.minY : Integer.MIN_VALUE, this.maxY != null ? this.maxY : Integer.MAX_VALUE, this.weight == null ? 1 : this.weight, this.size, this.probability == null ? 1 : this.probability, this.triangle, this.plateau == null ? 0 : this.plateau, this.spawnOnOceanFloor, this.dimensions, this.biomes, this.biomeBlacklist);
    }

    public final VanillaVeinBuilder withMaterial(Material material) {
        this.material = material;
        return this;
    }

    public final VanillaVeinBuilder withSecondaryMaterial(Material secondary, float secondaryChance) {
        this.secondary = secondary;
        this.secondaryChance = Float.valueOf(secondaryChance);
        return this;
    }

    public final VanillaVeinBuilder withSecondaryType(MaterialTypeBlock<?> materialType) {
        this.secondaryType = materialType;
        return this;
    }

    public final VanillaVeinBuilder withMaterialType(MaterialTypeBlock<?> materialType) {
        this.materialType = materialType;
        return this;
    }

    public final VanillaVeinBuilder withWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public final VanillaVeinBuilder withSize(int size) {
        this.size = size;
        return this;
    }

    public final VanillaVeinBuilder withDiscardOnExposureChance(float discardOnExposureChance) {
        this.discardOnExposureChance = Float.valueOf(discardOnExposureChance);
        return this;
    }

    public final VanillaVeinBuilder atHeight(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public final VanillaVeinBuilder withProbability(int probability) {
        this.probability = probability;
        return this;
    }

    public final VanillaVeinBuilder withBiomes(String ... biomes) {
        if (this.biomes.isEmpty() && biomes.length > 0) {
            this.biomeBlacklist = false;
        }
        Collections.addAll(this.biomes, biomes);
        return this;
    }

    public final VanillaVeinBuilder inDimension(ResourceKey<Level> dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public final VanillaVeinBuilder inDimensions(List<ResourceKey<Level>> dimension) {
        this.dimensions.addAll(dimension);
        return this;
    }

    @SafeVarargs
    public final VanillaVeinBuilder inDimensions(ResourceKey<Level> ... dimensions) {
        Collections.addAll(this.dimensions, dimensions);
        return this;
    }

    public final VanillaVeinBuilder setBiomeBlacklist(boolean blacklist) {
        this.biomeBlacklist = blacklist;
        return this;
    }

    public final VanillaVeinBuilder setHasTriangleHeight(boolean triangle) {
        this.triangle = triangle;
        return this;
    }

    public final VanillaVeinBuilder setHasTriangleHeight(boolean triangle, int plateau) {
        this.triangle = triangle;
        this.plateau = plateau;
        return this;
    }

    public final VanillaVeinBuilder setSpawnOnOceanFloor(boolean spawnOnOceanFloor) {
        this.spawnOnOceanFloor = spawnOnOceanFloor;
        return this;
    }
}

