/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.registration;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.MaterialDataInit;
import org.gtreimagined.gtlib.block.GTItemBlock;
import org.gtreimagined.gtlib.event.MaterialEvent;
import org.gtreimagined.gtlib.integration.kubejs.GTLibKubeJS;
import org.gtreimagined.gtlib.recipe.Recipe;
import org.gtreimagined.gtlib.recipe.condition.ConfigCondition;
import org.gtreimagined.gtlib.recipe.condition.TomlConfigCondition;
import org.gtreimagined.gtlib.registration.GTBiomeModifier;
import org.gtreimagined.gtlib.registration.IGTRegistrar;
import org.gtreimagined.gtlib.registration.IItemBlockProvider;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTArmor;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.gtreimagined.gtlib.worldgen.feature.IGTFeature;

@Mod.EventBusSubscriber(modid="gtlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class GTRegistration {
    @SubscribeEvent
    public static void onRegister(RegisterEvent e) {
        String domain = ModLoadingContext.get().getActiveNamespace();
        List list2 = GTAPI.all(IGTRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
        if (list2.size() < 4) {
            GTLib.LOGGER.info("Mod ID: " + domain + " & event: " + e.getRegistryKey().m_135782_());
        }
        GTRegistration.onRegister(domain, e);
        GTRegistration.onRegister("gt", e);
        List list = GTAPI.all(IGTRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
        list.forEach(r -> GTRegistration.onRegister(r.getId(), e));
    }

    public static void onRegister(String domain, RegisterEvent e) {
        ModContainer previous = ModLoadingContext.get().getActiveContainer();
        ModContainer newContainer = ModList.get().getModContainerById(domain).orElse(null);
        if (newContainer == null) {
            return;
        }
        if (!domain.equals("gtlib")) {
            ModLoadingContext.get().setActiveContainer(newContainer);
        }
        if (domain.equals("gtlib")) {
            List<IGTRegistrar> list = GTAPI.all(IGTRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).filter(IGTRegistrar::isEnabled).toList();
            if (e.getRegistryKey() == ForgeRegistries.Keys.SOUND_EVENTS) {
                GTAPI.onRegistration(RegistrationEvent.DATA_INIT);
                MaterialEvent event = new MaterialEvent();
                MaterialDataInit.onMaterialEvent(event);
                list.forEach(r -> r.onMaterialEvent(event));
                if (GTAPI.isModLoaded("kubejs")) {
                    GTLibKubeJS.loadMaterialEvent(event);
                }
                Data.postInit();
            }
            GTAPI.all(IRegistryEntryProvider.class, domain, p -> p.onRegistryBuild(e.getRegistryKey()));
            GTAPI.all(IRegistryEntryProvider.class, "gt", p -> p.onRegistryBuild(e.getRegistryKey()));
            list.forEach(r -> GTAPI.all(IRegistryEntryProvider.class, r.getDomain(), p -> p.onRegistryBuild(e.getRegistryKey())));
        }
        if (e.getRegistryKey() == ForgeRegistries.Keys.BLOCKS) {
            GTAPI.all(Block.class, domain, (b, d, i) -> {
                IItemBlockProvider pb;
                if (!(b instanceof IItemBlockProvider) || (pb = (IItemBlockProvider)b).generateItemBlock()) {
                    GTItemBlock gTItemBlock;
                    if (b instanceof IItemBlockProvider) {
                        IItemBlockProvider pb2 = (IItemBlockProvider)b;
                        gTItemBlock = pb2.getItemBlock();
                    } else {
                        gTItemBlock = new GTItemBlock((Block)b);
                    }
                    GTAPI.register(Item.class, i, d, gTItemBlock);
                }
                ForgeRegistries.BLOCKS.register(new ResourceLocation(d, i), b);
            });
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.ITEMS) {
            GTAPI.all(Item.class, domain, (it, d, i) -> ForgeRegistries.ITEMS.register(new ResourceLocation(d, i), it));
            GTRegistration.registerTools(domain);
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.BLOCK_ENTITY_TYPES) {
            GTAPI.all(BlockEntityType.class, domain, (t, d, i) -> ForgeRegistries.BLOCK_ENTITY_TYPES.register(new ResourceLocation(d, i), t));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.FLUIDS) {
            GTAPI.all(Fluid.class, domain, (f, d, i) -> ForgeRegistries.FLUIDS.register(new ResourceLocation(d, i), f));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.FLUID_TYPES) {
            GTAPI.all(FluidType.class, domain, (f, d, i) -> ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).register(new ResourceLocation(d, i), f));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.MENU_TYPES) {
            GTAPI.all(MenuType.class, domain, (h, d, i) -> ForgeRegistries.MENU_TYPES.register(new ResourceLocation(d, i), h));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.SOUND_EVENTS) {
            GTAPI.all(SoundEvent.class, domain, (t, d, i) -> ForgeRegistries.SOUND_EVENTS.register(new ResourceLocation(d, i), t));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.RECIPE_SERIALIZERS) {
            GTAPI.all(IIngredientSerializer.class, domain, (s, d, i) -> CraftingHelper.register((ResourceLocation)new ResourceLocation(d, i), (IIngredientSerializer)s));
            if (domain.equals("gtlib")) {
                CraftingHelper.register((IConditionSerializer)ConfigCondition.Serializer.INSTANCE);
                CraftingHelper.register((IConditionSerializer)TomlConfigCondition.Serializer.INSTANCE);
            }
            GTAPI.all(RecipeSerializer.class, domain, (r, d, i) -> ForgeRegistries.RECIPE_SERIALIZERS.register(new ResourceLocation(d, i), r));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.FEATURES) {
            GTAPI.all(IGTFeature.class, domain, (t, d, i) -> ForgeRegistries.FEATURES.register(new ResourceLocation(d, i), t.asFeature()));
        } else if (e.getRegistryKey() == ForgeRegistries.Keys.ENCHANTMENTS) {
            GTAPI.all(Enchantment.class, domain, (en, d, i) -> ForgeRegistries.ENCHANTMENTS.register(new ResourceLocation(d, i), en));
        }
        if (domain.equals("gtlib")) {
            if (e.getRegistryKey() == ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS) {
                ((IForgeRegistry)ForgeRegistries.BIOME_MODIFIER_SERIALIZERS.get()).register(new ResourceLocation("gtlib", "modifier"), GTBiomeModifier.CODEC);
            } else if (e.getRegistryKey() == ForgeRegistries.Keys.RECIPE_TYPES) {
                ForgeRegistries.RECIPE_TYPES.register(new ResourceLocation("gtlib", "machine"), Recipe.RECIPE_TYPE);
            }
        }
        if (!domain.equals("gtlib")) {
            ModLoadingContext.get().setActiveContainer(previous);
        }
    }

    public static void registerTools(String domain) {
        GTAPI.all(GTToolType.class, domain, t -> {
            List<IGTTool> tools = t.isPowered() ? t.instantiatePoweredTools(domain) : t.instantiateTools(domain);
            for (IGTTool i : tools) {
                ForgeRegistries.ITEMS.register(new ResourceLocation(domain, i.getId()), (Object)i.getItem());
            }
        });
        GTAPI.all(GTArmorType.class, domain, t -> {
            List<IGTArmor> i = t.instantiateTools();
            i.forEach(a -> ForgeRegistries.ITEMS.register(new ResourceLocation(domain, a.getId()), (Object)a.getItem()));
        });
    }
}

