/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.map;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.Recipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class RecipeBuilder {
    private static final Map<String, IRecipe> ID_MAP = new Object2ObjectArrayMap();
    private static String CURRENT_MOD_ID = "gt";
    protected RecipeMap<? extends RecipeBuilder> recipeMap;
    protected List<ItemStack> itemsOutput = new ObjectArrayList();
    protected List<Ingredient> ingredientInput = new ObjectArrayList();
    protected List<FluidIngredient> fluidsInput = new ObjectArrayList();
    protected List<FluidStack> fluidsOutput = new ObjectArrayList();
    protected int[] inputChances;
    protected int[] outputChances;
    protected int duration;
    protected int special;
    protected long power;
    protected int amps;
    protected boolean hidden;
    protected boolean fake;
    protected Set<String> tags = new ObjectOpenHashSet();
    protected ResourceLocation id;
    protected boolean recipeMapOnly = false;
    private Advancement.Builder advancementBuilder = null;

    public IRecipe add(String modid, String id) {
        this.id(modid, id);
        return this.build();
    }

    public IRecipe add(String id) {
        return this.add(this.recipeMap.getDomain(), id);
    }

    public static void clearList() {
        ID_MAP.clear();
    }

    public static Map<String, IRecipe> getIdMap() {
        return ID_MAP;
    }

    public static void setCurrentModId(String id) {
        CURRENT_MOD_ID = id;
    }

    protected void addToMap(IRecipe r) {
        this.recipeMap.add(r);
    }

    public IRecipe build() {
        if (this.itemsOutput != null && !this.itemsOutput.isEmpty() && !Utils.areItemsValid(this.itemsOutput.toArray(new ItemStack[0]))) {
            String id = this.id == null ? "" : " Recipe ID: " + this.id;
            Utils.onInvalidData("RECIPE BUILDER ERROR - OUTPUT ITEMS INVALID!" + id + " Recipe map ID:" + this.recipeMap.getLoc());
            return Utils.getEmptyRecipe();
        }
        if (this.fluidsOutput != null && !this.fluidsOutput.isEmpty() && !Utils.areFluidsValid(this.fluidsOutput.toArray(new FluidStack[0]))) {
            String id = this.id == null ? "" : " Recipe ID: " + this.id;
            Utils.onInvalidData("RECIPE BUILDER ERROR - OUTPUT FLUIDS INVALID!" + id + " Recipe map ID:" + this.recipeMap.getLoc());
            return Utils.getEmptyRecipe();
        }
        if (this.ingredientInput == null) {
            this.ingredientInput = Collections.emptyList();
        }
        if (this.amps < 1) {
            this.amps = 1;
        }
        IRecipe recipe = this.buildRecipe();
        if (!this.recipeMapOnly) {
            ResourceLocation advancementID;
            ResourceLocation resourceLocation = advancementID = this.advancementBuilder != null ? new ResourceLocation(this.id.m_135827_(), "recipes/" + this.id.m_135815_()) : null;
            if (this.advancementBuilder != null) {
                this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)this.id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.id)).m_138360_(RequirementsStrategy.f_15979_);
            }
            GTLibDynamics.FINISHED_RECIPE_CONSUMER.accept(new Result(this.id, recipe, advancementID));
        }
        return recipe;
    }

    protected IRecipe buildRecipe() {
        Recipe recipe = new Recipe(this.ingredientInput, this.itemsOutput != null ? this.itemsOutput.toArray(new ItemStack[0]) : null, this.fluidsInput != null ? this.fluidsInput : Collections.emptyList(), this.fluidsOutput != null ? this.fluidsOutput.toArray(new FluidStack[0]) : null, this.duration, this.power, this.special, this.amps);
        if (this.outputChances != null) {
            recipe.addOutputChances(this.outputChances);
        }
        if (this.inputChances != null) {
            recipe.addInputChances(this.inputChances);
        }
        recipe.setHidden(this.hidden);
        recipe.setFake(this.fake);
        recipe.addTags((Set<String>)new ObjectOpenHashSet(this.tags));
        recipe.setId(this.id);
        recipe.setMapId(this.recipeMap.getLoc().toString());
        return recipe;
    }

    public void getID() {
        if (this.id == null) {
            if (this.itemsOutput != null && !this.itemsOutput.isEmpty()) {
                String id = RegistryUtils.getIdFromItem(this.itemsOutput.get(0).m_41720_()).toString() + "_recipe";
                this.checkID(id);
            } else if (this.fluidsOutput != null && !this.fluidsOutput.isEmpty()) {
                String id = RegistryUtils.getIdFromFluid(this.fluidsOutput.get(0).getFluid()).toString() + "_recipe";
                this.checkID(id);
            } else if (!this.ingredientInput.isEmpty() && this.ingredientInput.get(0).m_43908_().length > 0) {
                ItemStack stack = this.ingredientInput.get(0).m_43908_()[0];
                String id = RegistryUtils.getIdFromItem(stack.m_41720_()).toString() + "_recipe";
                this.checkID(id);
            } else if (!this.fluidsInput.isEmpty()) {
                List<FluidStack> list;
                FluidIngredient ing = this.fluidsInput.get(0);
                String id = ing.getTag() != null ? ing.getTag().f_203868_().toString() + "_recipe" : (!(list = Arrays.asList(ing.getStacks())).isEmpty() ? RegistryUtils.getIdFromFluid(list.get(0).getFluid()).toString() + "_recipe" : "gtlib:unknown_in_" + this.recipeMap.getId());
                this.checkID(id);
            }
        }
    }

    private void checkID(String id) {
        if (ID_MAP.containsKey(id)) {
            String newID;
            int i = 1;
            do {
                newID = (String)id + "_" + i;
                ++i;
            } while (ID_MAP.containsKey(newID));
            id = newID;
        }
        this.id = new ResourceLocation((String)id);
    }

    public IRecipe add(String id, long duration, long power, long special) {
        return this.add(id, duration, power, special, 1);
    }

    public IRecipe add(String domain, String id, long duration, long power, long special, int amps) {
        this.duration = (int)duration;
        this.power = power;
        this.special = (int)special;
        this.amps = amps;
        return this.add(domain, id);
    }

    public IRecipe add(String id, long duration, long power, long special, int amps) {
        return this.add(CURRENT_MOD_ID, id, duration, power, special, amps);
    }

    public IRecipe add(String id, long duration, long power) {
        return this.add(id, duration, power, this.special);
    }

    public IRecipe add(String id, long duration) {
        return this.add(id, duration, 0L, this.special);
    }

    public RecipeBuilder ii(ItemLike ... stacks) {
        this.ingredientInput.addAll(Arrays.stream(stacks).map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).toList());
        return this;
    }

    public RecipeBuilder ii(Ingredient ... stacks) {
        this.ingredientInput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder ii(List<Ingredient> stacks) {
        this.ingredientInput.addAll(stacks);
        return this;
    }

    public RecipeBuilder io(ItemStack ... stacks) {
        this.itemsOutput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder io(Item ... stacks) {
        this.itemsOutput.addAll(Arrays.stream(stacks).map(Item::m_7968_).toList());
        return this;
    }

    public RecipeBuilder io(List<ItemStack> stacks) {
        this.itemsOutput.addAll(stacks);
        return this;
    }

    public RecipeBuilder fi(FluidStack ... stacks) {
        this.fluidsInput.addAll(Arrays.stream(stacks).map(FluidIngredient::of).toList());
        return this;
    }

    public RecipeBuilder fi(FluidIngredient ... stacks) {
        this.fluidsInput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder fi(List<FluidStack> stacks) {
        this.fluidsInput.addAll(stacks.stream().map(FluidIngredient::of).toList());
        return this;
    }

    public RecipeBuilder fo(FluidStack ... stacks) {
        this.fluidsOutput.addAll(Arrays.asList(stacks));
        return this;
    }

    public RecipeBuilder fo(List<FluidStack> stacks) {
        this.fluidsOutput.addAll(stacks);
        return this;
    }

    public RecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public RecipeBuilder id(String modid, String name) {
        return this.id(new ResourceLocation(modid, this.recipeMap.getId() + "/" + name));
    }

    public RecipeBuilder id(String name) {
        return this.id(this.recipeMap.getDomain(), name);
    }

    public RecipeBuilder outputChances(double ... values) {
        int[] newChances = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            double chance = values[i];
            newChances[i] = (int)(chance * 10000.0);
        }
        return this.outputChances(newChances);
    }

    public RecipeBuilder outputChances(int ... values) {
        this.outputChances = values;
        return this;
    }

    public RecipeBuilder inputChances(double ... values) {
        int[] newChances = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            double chance = values[i];
            newChances[i] = (int)(chance * 10000.0);
        }
        return this.inputChances(newChances);
    }

    public RecipeBuilder inputChances(int ... values) {
        this.inputChances = values;
        return this;
    }

    public RecipeBuilder hide() {
        this.hidden = true;
        return this;
    }

    public RecipeBuilder fake() {
        this.fake = true;
        return this;
    }

    public RecipeBuilder recipeMapOnly() {
        this.recipeMapOnly = true;
        return this;
    }

    public RecipeBuilder tags(String ... tags) {
        this.tags = new ObjectOpenHashSet((Object[])tags);
        return this;
    }

    public RecipeBuilder addCriterion(String name, CriterionTriggerInstance criterionIn) {
        if (this.advancementBuilder == null) {
            this.advancementBuilder = Advancement.Builder.m_138353_();
        }
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public RecipeBuilder clearItemInputs() {
        this.ingredientInput = new ObjectArrayList();
        this.inputChances = null;
        return this;
    }

    public RecipeBuilder clearItemOutputs() {
        this.itemsOutput = new ObjectArrayList();
        this.outputChances = null;
        return this;
    }

    public RecipeBuilder clearFluidInputs() {
        this.fluidsInput = new ObjectArrayList();
        return this;
    }

    public RecipeBuilder clearFluidOutputs() {
        this.fluidsOutput = new ObjectArrayList();
        return this;
    }

    public void clear() {
        this.itemsOutput = new ObjectArrayList();
        this.ingredientInput = new ObjectArrayList();
        this.fluidsInput = new ObjectArrayList();
        this.fluidsOutput = new ObjectArrayList();
        this.outputChances = null;
        this.inputChances = null;
        this.special = 0;
        this.duration = 0;
        this.power = 0L;
        this.hidden = false;
        this.fake = false;
        this.recipeMapOnly = false;
        this.tags.clear();
    }

    public RecipeMap<?> getMap() {
        return this.recipeMap;
    }

    public void setMap(RecipeMap<?> recipeMap) {
        this.recipeMap = recipeMap;
    }

    private class Result
    implements FinishedRecipe {
        ResourceLocation id;
        ResourceLocation advancementID = null;
        IRecipe recipe;

        public Result(ResourceLocation id, IRecipe recipe) {
            this.id = id;
            this.recipe = recipe;
        }

        public Result(ResourceLocation id, IRecipe recipe, ResourceLocation advancementID) {
            this.id = id;
            this.recipe = recipe;
            this.advancementID = advancementID;
        }

        public void m_7917_(JsonObject json) {
            RecipeBuilder.this.recipeMap.getRecipeSerializer().toJson(json, this.recipe);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeBuilder.this.recipeMap.getRecipeSerializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            if (RecipeBuilder.this.advancementBuilder != null) {
                return RecipeBuilder.this.advancementBuilder.m_138400_();
            }
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementID;
        }
    }
}

