/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe.types;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;

public abstract class PipeType<T extends PipeType<T>>
implements IRegistryEntryProvider,
ISharedGTObject {
    public final String domain;
    protected Material material;
    protected ImmutableSet<PipeSize> sizes = ImmutableSet.of();
    protected BlockEntityType<? extends BlockEntityPipe<?>> tileType;
    protected Map<PipeSize, Block> registeredBlocks;
    protected final BlockEntityBase.BlockEntitySupplier<BlockEntityPipe<?>, T> tileFunc;

    public PipeType(String domain, Material material, BlockEntityBase.BlockEntitySupplier<BlockEntityPipe<?>, T> func) {
        this.domain = domain;
        this.material = material;
        this.sizes(PipeSize.VALUES);
        this.tileFunc = func;
    }

    @Override
    public void onRegistryBuild(ResourceKey<? extends Registry<?>> registry) {
        if (registry != ForgeRegistries.Keys.BLOCKS) {
            return;
        }
        Set<Block> blocks = this.getBlocks();
        this.registeredBlocks = blocks.stream().map(t -> new Pair((Object)((BlockPipe)t).getSize(), t)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.tileType = new BlockEntityType((pos, state) -> this.tileFunc.create(this, pos, state), blocks, null);
        GTAPI.register(BlockEntityType.class, this.getId(), this.getDomain(), this.getTileType());
    }

    public Block getBlock(PipeSize size) {
        return this.registeredBlocks.get(size);
    }

    public PipeItemBlock getBlockItem(PipeSize size) {
        return (PipeItemBlock)Item.f_41373_.get(this.getBlock(size));
    }

    public abstract Set<Block> getBlocks();

    public abstract String getType();

    @Override
    public String getId() {
        return this.getType() + "_" + this.material.getId();
    }

    public abstract String getTypeName();

    public BlockEntityType<?> getTileType() {
        return this.tileType;
    }

    public T sizes(PipeSize ... sizes) {
        this.sizes = ImmutableSet.copyOf((Object[])sizes);
        return (T)this;
    }

    public String getSizeId(PipeSize size) {
        return size.getId();
    }

    public String createId(PipeSize size, String suffix) {
        return this.getSizeId(size) + "_" + this.material.getId() + "_" + suffix;
    }

    public String getModelPath(PipeSize size) {
        return "pipe/" + (switch (size) {
            case PipeSize.HUGE -> "12x12";
            case PipeSize.LARGE -> "10x10";
            case PipeSize.NORMAL -> "8x8";
            case PipeSize.SMALL -> "6x6";
            case PipeSize.TINY -> "4x4";
            case PipeSize.VTINY -> "2x2";
            default -> "";
        });
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public ImmutableSet<PipeSize> getSizes() {
        return this.sizes;
    }
}

