/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Pair;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialStack;
import org.gtreimagined.gtlib.material.MaterialTag;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.data.ArmorData;
import org.gtreimagined.gtlib.material.data.HandleData;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.material.tags.BlockDropMaterialTag;
import org.gtreimagined.gtlib.material.tags.DoubleMaterialTag;
import org.gtreimagined.gtlib.material.tags.ListMaterialTag;
import org.gtreimagined.gtlib.material.tags.MapMaterialTag;
import org.gtreimagined.gtlib.material.tags.NumberMaterialTag;
import org.gtreimagined.gtlib.material.tags.TypeMaterialTag;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;

public class MaterialTags {
    public static final MaterialTag RUBBERTOOLS = new MaterialTag("rubber_tools");
    public static final MaterialTag WOOD = new MaterialTag("wood");
    public static final MaterialTag MINED_WITH_AXE = new MaterialTag("mined_with_axe");
    public static final MaterialTag HAS_CUSTOM_SMELTING = new MaterialTag("has_custom_smelting");
    public static final MaterialTag TRANSPARENT = new MaterialTag("transparent");
    public static final MaterialTag METAL = new MaterialTag("metal");
    public static final MaterialTag ELEMENTAL = new MaterialTag("elemental");
    public static final NumberMaterialTag RADIOACTIVE = new NumberMaterialTag("radioactive");
    public static final MaterialTag FLINT = new MaterialTag("flint");
    public static final MaterialTag MOLTEN = new MaterialTag("molten");
    public static final MaterialTag ACID = new MaterialTag("acid");
    public static final MaterialTag POSITIVE_CHANGING_RGB = new MaterialTag("positive_changing_rgb");
    public static final MaterialTag NEGATIVE_CHANGING_RGB = new MaterialTag("negative_changing_rgb");
    public static final NumberMaterialTag ORE_RGB = new NumberMaterialTag("ore_rgb");
    public static final MaterialTag QUARTZ_LIKE_BLOCKS = new MaterialTag("quartz_like_blocks");
    public static final TypeMaterialTag<UniformInt> EXP_RANGE = new TypeMaterialTag("exp_range");
    public static final TypeMaterialTag<HandleData> HANDLE = new TypeMaterialTag<HandleData>("handle"){

        @Override
        public HandleData get(Material mat) {
            if (mat == Material.NULL) {
                return this.mapping.computeIfAbsent(mat, m -> new HandleData(0, 0.0f, (ImmutableMap<Enchantment, Integer>)ImmutableMap.of()));
            }
            return (HandleData)super.get(mat);
        }
    };
    public static final MaterialTag ITEMPIPE = new MaterialTag("itempipe");
    public static final MaterialTag FLUIDPIPE = new MaterialTag("fluidpipe");
    public static final MaterialTag WIRE = new MaterialTag("wire");
    public static final MaterialTag CABLE = new MaterialTag("cable");
    public static final DoubleMaterialTag SMELT_INTO = new DoubleMaterialTag("smelt_into");
    public static final DoubleMaterialTag DIRECT_SMELT_INTO = new DoubleMaterialTag("direct_smelt_into");
    public static final DoubleMaterialTag ARC_SMELT_INTO = new DoubleMaterialTag("arc_smelt_into");
    public static final DoubleMaterialTag MACERATE_INTO = new DoubleMaterialTag("macerate_into");
    public static final DoubleMaterialTag MELT_INTO = new DoubleMaterialTag("melt_into");
    public static final NumberMaterialTag MELTING_POINT = (NumberMaterialTag)new NumberMaterialTag("melting_point").setDefaultValue(m -> 295);
    public static final NumberMaterialTag MINING_LEVEL = new NumberMaterialTag("mining_level");
    public static final NumberMaterialTag FUEL_POWER = (NumberMaterialTag)new NumberMaterialTag("fuel_power").setDefaultValue(m -> 0);
    public static final NumberMaterialTag LIQUID_TEMPERATURE = (NumberMaterialTag)new NumberMaterialTag("liquid_temperature").setDefaultValue(mat -> Math.max((Integer)MELTING_POINT.get((Material)mat), 295));
    public static final NumberMaterialTag GAS_TEMPERATURE = (NumberMaterialTag)new NumberMaterialTag("gas_temperature").setDefaultValue(mat -> Math.max((Integer)MELTING_POINT.get((Material)mat), 295));
    public static final NumberMaterialTag FLUID_DENSITY = new NumberMaterialTag("fluid_density");
    public static final NumberMaterialTag ORE_MULTI = new NumberMaterialTag("ore_multi");
    public static final NumberMaterialTag SMELTING_MULTI = new NumberMaterialTag("smelting_multi");
    public static final NumberMaterialTag BY_PRODUCT_MULTI = new NumberMaterialTag("by_product_multi");
    public static final TypeMaterialTag<Consumer<FluidType.Properties>> FLUID_TYPE_PROPERTIES = new TypeMaterialTag("fluid_type_properties");
    public static final TypeMaterialTag<Pair<List<MaterialStack>, Integer>> PROCESS_INTO = new TypeMaterialTag("process_into");
    public static final ListMaterialTag<Material> BYPRODUCTS = new ListMaterialTag("byproducts");
    public static final BlockDropMaterialTag<BlockOre> CUSTOM_ORE_DROPS = new BlockDropMaterialTag("custom_ore_drops");
    public static final BlockDropMaterialTag<BlockOreStone> CUSTOM_ORE_STONE_DROPS = new BlockDropMaterialTag("custom_ore_stone_drops");
    public static final MapMaterialTag<MaterialType<?>, Integer> FURNACE_FUELS = new MapMaterialTag("furnace_fuels");
    public static final MaterialTag NOSMASH = new MaterialTag("no_smash");
    public static TypeMaterialTag<ToolData> TOOLS = new TypeMaterialTag<ToolData>("tools"){

        @Override
        public ToolData get(Material mat) {
            if (mat == Material.NULL) {
                return this.mapping.computeIfAbsent(mat, m -> new ToolData(5.0f, 5.0f, Integer.MAX_VALUE, 3, GTLibMaterials.Wood, (ImmutableMap<Enchantment, Integer>)ImmutableMap.of(), List.of()));
            }
            return (ToolData)super.get(mat);
        }
    };
    public static TypeMaterialTag<ArmorData> ARMOR = new TypeMaterialTag<ArmorData>("armor"){

        @Override
        public ArmorData get(Material mat) {
            if (mat == Material.NULL) {
                return this.mapping.computeIfAbsent(mat, m -> new ArmorData(new int[]{1, 1, 1, 1}, 0.0f, 0.0f, 23, (ImmutableMap<Enchantment, Integer>)ImmutableMap.of()));
            }
            return (ArmorData)super.get(mat);
        }
    };
}

