/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine;

import lombok.Generated;
import net.minecraft.ChatFormatting;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.texture.Texture;

public class Tier
implements ISharedGTObject {
    public static Tier ULV = new Tier("gtlib", "ulv", 8L, ChatFormatting.DARK_RED, 0);
    public static Tier LV = new Tier("gtlib", "lv", 32L, ChatFormatting.GRAY, 1);
    public static Tier MV = new Tier("gtlib", "mv", 128L, ChatFormatting.GOLD, 2);
    public static Tier HV = new Tier("gtlib", "hv", 512L, ChatFormatting.YELLOW, 3);
    public static Tier EV = new Tier("gtlib", "ev", 2048L, ChatFormatting.AQUA, 4);
    public static Tier IV = new Tier("gtlib", "iv", 8192L, ChatFormatting.GREEN, 5);
    public static Tier LUV = new Tier("gtlib", "luv", 32768L, ChatFormatting.LIGHT_PURPLE, 6);
    public static Tier ZPM = new Tier("gtlib", "zpm", 131072L, ChatFormatting.BLUE, 7);
    public static Tier UV = new Tier("gtlib", "uv", 524288L, ChatFormatting.DARK_GREEN, 8);
    public static Tier UHV = new Tier("gtlib", "uhv", 0x200000L, ChatFormatting.DARK_RED, 9);
    public static Tier UEV = new Tier("gtlib", "uev", 0x800000L, ChatFormatting.DARK_PURPLE, 10);
    public static Tier UIV = new Tier("gtlib", "uiv", 35544432L, ChatFormatting.DARK_BLUE, 11);
    public static Tier UMV = new Tier("gtlib", "umv", 0x8000000L, ChatFormatting.RED, 12);
    public static Tier UXV = new Tier("gtlib", "uxv", 0x20000000L, ChatFormatting.DARK_RED, 13);
    public static Tier MAX = new Tier("gtlib", "max", 0x80000000L, ChatFormatting.WHITE, 14);
    public static Tier BRONZE = new Tier("gtlib", "bronze", 0L, ChatFormatting.WHITE);
    public static Tier STEEL = new Tier("gtlib", "steel", 0L, ChatFormatting.WHITE);
    public static Tier NONE = new Tier("gtlib", "none", 0L, ChatFormatting.WHITE);
    private final String domain;
    private final String id;
    private final long voltage;
    private final int integerId;
    private final ChatFormatting rarityFormatting;
    private final String baseTexture;

    public Tier(String domain, String id, long voltage, ChatFormatting rarityFormatting) {
        this(domain, id, voltage, rarityFormatting, 1);
    }

    public Tier(String domain, String id, long voltage, ChatFormatting rarityFormatting, int integerId) {
        this.domain = domain;
        this.id = id;
        this.voltage = voltage;
        this.rarityFormatting = rarityFormatting;
        this.baseTexture = "block/machine/base/" + id;
        this.integerId = integerId;
        GTAPI.register(Tier.class, this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Texture getBaseTexture(String domain) {
        return new Texture(domain, this.baseTexture);
    }

    public static Tier[] getSteam() {
        return new Tier[]{BRONZE, STEEL};
    }

    public static Tier[] getStandard() {
        return new Tier[]{LV, MV, HV, EV};
    }

    public static Tier[] getStandardWithIV() {
        return new Tier[]{LV, MV, HV, EV, IV};
    }

    public static Tier[] getAllElectric() {
        return new Tier[]{ULV, LV, MV, HV, EV, IV, LUV, ZPM, UV, UHV};
    }

    public static Tier[] getBasic() {
        return new Tier[]{BRONZE, STEEL, LV, MV, HV, EV, IV};
    }

    public static Tier getMax() {
        return IV;
    }

    public static Texture[] getTextures(String domain, Tier ... tiers) {
        Texture[] textures = new Texture[tiers.length];
        for (int i = 0; i < tiers.length; ++i) {
            textures[i] = tiers[i].getBaseTexture(domain);
        }
        return textures;
    }

    public static Tier getTier(long voltage) {
        for (Tier tier : Tier.getAllElectric()) {
            if (voltage > tier.getVoltage()) continue;
            return tier;
        }
        return ULV;
    }

    @Generated
    public long getVoltage() {
        return this.voltage;
    }

    @Generated
    public int getIntegerId() {
        return this.integerId;
    }

    @Generated
    public ChatFormatting getRarityFormatting() {
        return this.rarityFormatting;
    }
}

