/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTCreativeTabs;
import org.gtreimagined.gtlib.registration.ICreativeTabProvider;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemBasic<T extends ItemBasic<T>>
extends Item
implements IGTObject,
ITextureProvider,
IModelProvider,
ICreativeTabProvider {
    protected String domain;
    protected String id;
    protected String tooltip = "";
    protected String subDir = "";
    protected boolean enabled = true;
    protected ResourceKey<CreativeModeTab> tab = GTCreativeTabs.ITEMS.getKey();

    public ItemBasic(String domain, String id, String subDir, Item.Properties properties) {
        super(properties);
        this.domain = domain;
        this.id = id;
        this.subDir = subDir;
        GTAPI.register(this.getClass(), this);
        if (this.getClass() != ItemBasic.class) {
            GTAPI.register(ItemBasic.class, this);
        }
    }

    public ItemBasic(String domain, String id, Item.Properties properties) {
        this(domain, id, "", properties);
    }

    public ItemBasic(String domain, String id, Class clazz, Item.Properties properties) {
        super(properties);
        this.domain = domain;
        this.id = id;
        GTAPI.register(clazz, this);
    }

    public ItemBasic(String domain, String id) {
        this(domain, id, "", new Item.Properties());
    }

    public ItemBasic(String domain, String id, String subDir) {
        this(domain, id, subDir, new Item.Properties());
    }

    @Override
    public boolean allowedIn(ResourceKey<CreativeModeTab> tab) {
        return tab == this.tab;
    }

    public T tab(ResourceKey<CreativeModeTab> tab) {
        this.tab = tab;
        return (T)this;
    }

    public T tip(String tooltip) {
        this.tooltip = tooltip;
        return (T)this;
    }

    @Override
    public String getDomain() {
        return this instanceof ISharedGTObject ? "gt" : this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ItemStack get(int count) {
        return new ItemStack((ItemLike)this, count);
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.domain, "item/basic/" + this.subDir + this.getId())};
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (!this.tooltip.isEmpty()) {
            tooltipComponents.add((Component)Utils.translatable("tooltip." + this.getDomain() + "." + this.getId().replace("/", "."), new Object[0]));
        }
    }

    @Generated
    public String getTooltip() {
        return this.tooltip;
    }

    @Generated
    public String getSubDir() {
        return this.subDir;
    }
}

