/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.kubejs;

import dev.latvian.mods.kubejs.event.EventJS;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.machine.types.MultiMachine;
import org.gtreimagined.gtlib.material.Element;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.TextureSet;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GTCreationEvent
extends EventJS {
    public static final Map<String, SoundType> SOUND_TYPE_REGISTRY = new Object2ObjectOpenHashMap();

    public StoneType createStoneType(String id, String material, String texture, SoundType soundType, boolean generateBlock) {
        return GTAPI.register(StoneType.class, new StoneType("kubejs", id, Material.get(material), new Texture(texture), soundType, generateBlock));
    }

    public StoneType createStoneType(String id, String material, String texture, SoundType soundType, String stoneState) {
        return GTAPI.register(StoneType.class, new StoneType("kubejs", id, Material.get(material), new Texture(texture), soundType, false).setStateSupplier(() -> RegistryUtils.getBlockFromId(new ResourceLocation(stoneState)).m_49966_()));
    }

    public Material createMaterial(String id, int rgb, String textureSet, String textureSetDomain) {
        TextureSet set = Objects.requireNonNull(GTAPI.get(TextureSet.class, textureSet, textureSetDomain), "Specified texture set in Material created via kubejs event is null");
        return GTAPI.register(Material.class, new Material("kubejs", id, rgb, set, new String[0]));
    }

    public Material createMaterial(String id, int rgb, String textureSet, String textureSetDomain, String element) {
        TextureSet set = Objects.requireNonNull(GTAPI.get(TextureSet.class, textureSet, textureSetDomain), "Specified texture set in Material created via kubejs event is null");
        return GTAPI.register(Material.class, new Material("kubejs", id, rgb, set, Element.getFromElementId(element), new String[0]));
    }

    public BasicMachine createBasicMachine(String id) {
        return new BasicMachine("kubejs", id);
    }

    public MultiMachine createMultiMachine(String id) {
        return new MultiMachine("kubejs", id);
    }

    public BasicMultiMachine createBasicMultiMachine(String id) {
        return new BasicMultiMachine("kubejs", id);
    }

    public Machine createMachine(String id) {
        return new Machine("kubejs", id);
    }

    public RecipeMap createRecipeMap(String id) {
        return new RecipeMap<RecipeBuilder>("kubejs", id, new RecipeBuilder());
    }

    public void addFlagsToMaterial(String materialId, String ... flags) {
        if (Material.get(materialId) != Material.NULL) {
            for (String flag : flags) {
                IMaterialTag tag = GTAPI.get(IMaterialTag.class, flag);
                if (tag == null) continue;
                Material.get(materialId).flags(this.type(flag));
            }
        }
    }

    public MaterialType type(String type) {
        return GTAPI.get(MaterialType.class, type);
    }

    public RecipeMap recipeMap(String id) {
        return GTAPI.get(RecipeMap.class, new ResourceLocation(id));
    }

    public SlotType slotType(String id) {
        return GTAPI.get(SlotType.class, id, "gtlib");
    }

    public static void init() {
        SOUND_TYPE_REGISTRY.put("wood", SoundType.f_56736_);
        SOUND_TYPE_REGISTRY.put("gravel", SoundType.f_56739_);
        SOUND_TYPE_REGISTRY.put("grass", SoundType.f_56740_);
        SOUND_TYPE_REGISTRY.put("lily_pad", SoundType.f_56741_);
        SOUND_TYPE_REGISTRY.put("stone", SoundType.f_56742_);
        SOUND_TYPE_REGISTRY.put("metal", SoundType.f_56743_);
        SOUND_TYPE_REGISTRY.put("glass", SoundType.f_56744_);
        SOUND_TYPE_REGISTRY.put("wool", SoundType.f_56745_);
        SOUND_TYPE_REGISTRY.put("sand", SoundType.f_56746_);
        SOUND_TYPE_REGISTRY.put("snow", SoundType.f_56747_);
        SOUND_TYPE_REGISTRY.put("powder_snow", SoundType.f_154681_);
        SOUND_TYPE_REGISTRY.put("ladder", SoundType.f_56748_);
        SOUND_TYPE_REGISTRY.put("anvil", SoundType.f_56749_);
        SOUND_TYPE_REGISTRY.put("slime_block", SoundType.f_56750_);
        SOUND_TYPE_REGISTRY.put("honey_block", SoundType.f_56751_);
        SOUND_TYPE_REGISTRY.put("wet_grass", SoundType.f_56752_);
        SOUND_TYPE_REGISTRY.put("coral_block", SoundType.f_56753_);
        SOUND_TYPE_REGISTRY.put("bamboo", SoundType.f_56754_);
        SOUND_TYPE_REGISTRY.put("bamboo_sapling", SoundType.f_56755_);
        SOUND_TYPE_REGISTRY.put("scaffolding", SoundType.f_56756_);
        SOUND_TYPE_REGISTRY.put("sweet_berry_bush", SoundType.f_56757_);
        SOUND_TYPE_REGISTRY.put("crop", SoundType.f_56758_);
        SOUND_TYPE_REGISTRY.put("hard_crop", SoundType.f_56759_);
        SOUND_TYPE_REGISTRY.put("vine", SoundType.f_56760_);
        SOUND_TYPE_REGISTRY.put("nether_wart", SoundType.f_56761_);
        SOUND_TYPE_REGISTRY.put("lantern", SoundType.f_56762_);
        SOUND_TYPE_REGISTRY.put("stem", SoundType.f_56763_);
        SOUND_TYPE_REGISTRY.put("nylium", SoundType.f_56710_);
        SOUND_TYPE_REGISTRY.put("fungus", SoundType.f_56711_);
        SOUND_TYPE_REGISTRY.put("roots", SoundType.f_56712_);
        SOUND_TYPE_REGISTRY.put("shroomlight", SoundType.f_56713_);
        SOUND_TYPE_REGISTRY.put("weeping_vines", SoundType.f_56714_);
        SOUND_TYPE_REGISTRY.put("twisting_vines", SoundType.f_56715_);
        SOUND_TYPE_REGISTRY.put("soul_sand", SoundType.f_56716_);
        SOUND_TYPE_REGISTRY.put("soul_soil", SoundType.f_56717_);
        SOUND_TYPE_REGISTRY.put("basalt", SoundType.f_56718_);
        SOUND_TYPE_REGISTRY.put("wart_block", SoundType.f_56719_);
        SOUND_TYPE_REGISTRY.put("netherrack", SoundType.f_56720_);
        SOUND_TYPE_REGISTRY.put("nether_bricks", SoundType.f_56721_);
        SOUND_TYPE_REGISTRY.put("nether_sprouts", SoundType.f_56722_);
        SOUND_TYPE_REGISTRY.put("nether_ore", SoundType.f_56723_);
        SOUND_TYPE_REGISTRY.put("bone_block", SoundType.f_56724_);
        SOUND_TYPE_REGISTRY.put("netherite_block", SoundType.f_56725_);
        SOUND_TYPE_REGISTRY.put("ancient_debris", SoundType.f_56726_);
        SOUND_TYPE_REGISTRY.put("lodestone", SoundType.f_56727_);
        SOUND_TYPE_REGISTRY.put("chain", SoundType.f_56728_);
        SOUND_TYPE_REGISTRY.put("nether_gold_ore", SoundType.f_56729_);
        SOUND_TYPE_REGISTRY.put("gilded_blackstone", SoundType.f_56730_);
        SOUND_TYPE_REGISTRY.put("candle", SoundType.f_154653_);
        SOUND_TYPE_REGISTRY.put("amethyst", SoundType.f_154654_);
        SOUND_TYPE_REGISTRY.put("amethyst_cluster", SoundType.f_154655_);
        SOUND_TYPE_REGISTRY.put("small_amethyst_bud", SoundType.f_154656_);
        SOUND_TYPE_REGISTRY.put("medium_amethyst_bud", SoundType.f_154657_);
        SOUND_TYPE_REGISTRY.put("large_amethyst_bud", SoundType.f_154658_);
        SOUND_TYPE_REGISTRY.put("tuff", SoundType.f_154659_);
        SOUND_TYPE_REGISTRY.put("calcite", SoundType.f_154660_);
        SOUND_TYPE_REGISTRY.put("dripstone_block", SoundType.f_154661_);
        SOUND_TYPE_REGISTRY.put("pointed_dripstone", SoundType.f_154662_);
        SOUND_TYPE_REGISTRY.put("copper", SoundType.f_154663_);
        SOUND_TYPE_REGISTRY.put("cave_vines", SoundType.f_154664_);
        SOUND_TYPE_REGISTRY.put("spore_blossom", SoundType.f_154665_);
        SOUND_TYPE_REGISTRY.put("azalea", SoundType.f_154666_);
        SOUND_TYPE_REGISTRY.put("flowering_azalea", SoundType.f_154667_);
        SOUND_TYPE_REGISTRY.put("moss_carpet", SoundType.f_154668_);
        SOUND_TYPE_REGISTRY.put("moss", SoundType.f_154669_);
        SOUND_TYPE_REGISTRY.put("big_dripleaf", SoundType.f_154670_);
        SOUND_TYPE_REGISTRY.put("small_dripleaf", SoundType.f_154671_);
        SOUND_TYPE_REGISTRY.put("rooted_dirt", SoundType.f_154672_);
        SOUND_TYPE_REGISTRY.put("hanging_roots", SoundType.f_154673_);
        SOUND_TYPE_REGISTRY.put("azalea_leaves", SoundType.f_154674_);
        SOUND_TYPE_REGISTRY.put("sculk_sensor", SoundType.f_154675_);
        SOUND_TYPE_REGISTRY.put("glow_lichen", SoundType.f_154676_);
        SOUND_TYPE_REGISTRY.put("deepslate", SoundType.f_154677_);
        SOUND_TYPE_REGISTRY.put("deepslate_bricks", SoundType.f_154678_);
        SOUND_TYPE_REGISTRY.put("deepslate_tiles", SoundType.f_154679_);
        SOUND_TYPE_REGISTRY.put("polished_deepslate", SoundType.f_154680_);
    }

    public SoundType soundType(String id) {
        return SOUND_TYPE_REGISTRY.getOrDefault(id, SoundType.f_56742_);
    }
}

