/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;
import org.gtreimagined.gtlib.integration.emi.GTEMIFluidIngredient;
import org.gtreimagined.gtlib.integration.emi.GTFluidEmiStack;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class RecipeMapRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final IRecipe recipe;
    private final List<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
    private final List<EmiStack> outputs = new ArrayList<EmiStack>();
    GuiData gui;
    Tier guiTier;
    int fluidInputOffset;
    int fluidOutputOffset;
    ResourceLocation id;
    IRecipeMap map;

    public RecipeMapRecipe(EmiRecipeCategory category, IRecipe recipe, GuiData gui, Tier guiTier) {
        this.category = category;
        this.recipe = recipe;
        this.gui = gui;
        this.guiTier = guiTier;
        this.recipe.getInputItems().forEach(i -> this.inputs.add(EmiIngredient.of((Ingredient)i)));
        this.fluidInputOffset = this.inputs.size();
        this.recipe.getInputFluids().forEach(f -> this.inputs.add(new GTEMIFluidIngredient((FluidIngredient)f)));
        if (this.recipe.hasOutputItems()) {
            for (ItemStack itemStack : this.recipe.getOutputItems(false)) {
                this.outputs.add(EmiStack.of((ItemStack)itemStack));
            }
        }
        this.fluidOutputOffset = this.outputs.size();
        if (recipe.hasOutputFluids()) {
            for (ItemStack itemStack : recipe.getOutputFluids()) {
                this.outputs.add((EmiStack)new GTFluidEmiStack(itemStack.getFluid(), itemStack.getTag(), itemStack.getAmount()));
            }
        }
        this.map = GTAPI.get(RecipeMap.class, recipe.getMapLoc());
        this.id = recipe.getTags().contains("emi_proxy") ? new ResourceLocation(recipe.m_6423_().m_135827_(), "/" + recipe.m_6423_().m_135815_()) : recipe.m_6423_();
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return this.gui.getArea().z;
    }

    public int getDisplayHeight() {
        return this.gui.getArea().w + (this.map.getInfoRenderer().getRows() <= 0 ? 0 : 7 + 10 * this.map.getInfoRenderer().getRows());
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int offsetIndex;
        SlotWidget slot;
        int s;
        List<SlotData<AbstractSlot>> slots;
        int slotCount;
        int offsetX = this.gui.getArea().x;
        int offsetY = this.gui.getArea().y;
        if (this.recipe.hasInputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_IN, this.guiTier)).size()) > 0) {
            if (!this.inputs.isEmpty()) {
                int recipeSlotCount = Math.min(slotCount, this.fluidInputOffset);
                for (s = 0; s < slotCount; ++s) {
                    Ingredient ingredient;
                    if (s >= recipeSlotCount) {
                        widgetHolder.addSlot(slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                        continue;
                    }
                    slot = widgetHolder.addSlot(this.inputs.get(s), slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                    if (this.recipe.getInputItems().size() > s && (ingredient = this.recipe.getInputItems().get(s)) instanceof RecipeIngredient) {
                        RecipeIngredient ri = (RecipeIngredient)ingredient;
                        if (ri.ignoreConsume()) {
                            slot.appendTooltip((Component)Utils.literal("Does not get consumed in the process.").m_130940_(ChatFormatting.WHITE));
                        }
                        if (ri.ignoreNbt()) {
                            slot.appendTooltip((Component)Utils.literal("Ignores NBT.").m_130940_(ChatFormatting.WHITE));
                        }
                        if (RecipeMap.isIngredientSpecial(ri)) {
                            slot.appendTooltip((Component)Utils.literal("Special ingredient. Class name: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Utils.literal(((Object)((Object)ri)).getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD)));
                        }
                    }
                    if (!this.recipe.hasInputChances() || this.recipe.getInputChances()[s] >= 10000) continue;
                    slot.appendTooltip((Component)Utils.literal("Consumption Chance: " + (float)this.recipe.getInputChances()[s] / 100.0f + "%").m_130940_(ChatFormatting.WHITE));
                }
            }
        }
        if (this.recipe.hasOutputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier)).size()) > 0) {
            int recipeSlotCount = Math.min(slotCount, this.fluidOutputOffset);
            for (int s2 = 0; s2 < slotCount; ++s2) {
                if (s2 >= recipeSlotCount) {
                    widgetHolder.addSlot(slots.get(s2).getX() - (offsetX - 1), slots.get(s2).getY() - (offsetY - 1)).recipeContext((EmiRecipe)this);
                    continue;
                }
                slot = widgetHolder.addSlot((EmiIngredient)this.outputs.get(s2), slots.get(s2).getX() - (offsetX - 1), slots.get(s2).getY() - (offsetY - 1)).recipeContext((EmiRecipe)this);
                if (!this.recipe.hasOutputChances() || this.recipe.getOutputChances()[s2] >= 10000) continue;
                slot.appendTooltip((Component)Utils.literal("Output Chance: " + (float)this.recipe.getOutputChances()[s2] / 100.0f + "%").m_130940_(ChatFormatting.WHITE));
            }
        }
        if (this.recipe.hasInputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_IN, this.guiTier)).size()) > 0) {
            for (s = 0; s < slotCount; ++s) {
                offsetIndex = s + this.fluidInputOffset;
                widgetHolder.addTexture(slots.get(s).getTexture(), slots.get(s).getX() - offsetX, slots.get(s).getY() - offsetY, 18, 18, 0, 0, 18, 18, 18, 18);
                if (offsetIndex >= this.inputs.size()) continue;
                widgetHolder.addTank(this.inputs.get(offsetIndex), slots.get(s).getX() - offsetX, slots.get(s).getY() - offsetY, 18, 18, this.recipe.getInputFluids().get(s).getAmount()).drawBack(false);
            }
        }
        if (this.recipe.hasOutputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_OUT, this.guiTier)).size()) > 0) {
            for (s = 0; s < slotCount; ++s) {
                offsetIndex = s + this.fluidOutputOffset;
                widgetHolder.addTexture(slots.get(s).getTexture(), slots.get(s).getX() - offsetX, slots.get(s).getY() - offsetY, 18, 18, 0, 0, 18, 18, 18, 18);
                if (offsetIndex >= this.outputs.size()) continue;
                widgetHolder.addTank((EmiIngredient)this.outputs.get(offsetIndex), slots.get(s).getX() - offsetX, slots.get(s).getY() - offsetY, 18, 18, this.recipe.getOutputFluids()[s].getAmount()).drawBack(false).recipeContext((EmiRecipe)this);
            }
        }
    }
}

