/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.integration.emi.recipe.RecipeMapRecipe;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.item.ScannerItem;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.SubCategory;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.int4;

@EmiEntrypoint
public class GTLibEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry emiRegistry) {
        if (FMLEnvironment.production) {
            return;
        }
        ArrayList list = new ArrayList();
        GTLibXEIPlugin.getItemsToHide().forEach(c -> c.accept(list));
        if (!list.isEmpty()) {
            emiRegistry.removeEmiStacks(s -> {
                Item i;
                Object patt1898$temp = s.getKey();
                return patt1898$temp instanceof Item && list.contains(i = (Item)patt1898$temp);
            });
        }
        ArrayList fluidList = new ArrayList();
        GTLibXEIPlugin.getFluidsToHide().forEach(c -> c.accept(fluidList));
        List<Item> buckets = fluidList.stream().map(Fluid::m_6859_).toList();
        if (!fluidList.isEmpty()) {
            emiRegistry.removeEmiStacks(s -> {
                Fluid f;
                Object patt2246$temp = s.getKey();
                return patt2246$temp instanceof Fluid && fluidList.contains(f = (Fluid)patt2246$temp);
            });
            emiRegistry.removeEmiStacks(s -> {
                Item i;
                Object patt2348$temp = s.getKey();
                return patt2348$temp instanceof Item && buckets.contains(i = (Item)patt2348$temp);
            });
        }
        GTLibXEIPlugin.getREGISTRY().forEach((id, tuple) -> {
            GuiData gui = tuple.gui;
            int4 area = gui.getArea();
            Tier tier = tuple.map.getGuiTier() != null ? tuple.map.getGuiTier() : tuple.tier;
            EmiRecipeCategory mainCategory = new EmiRecipeCategory(tuple.map.getLoc(), this.createIcon(tuple.map.getIcon(), tuple.workstations.isEmpty() ? null : tuple.workstations.get(0)));
            emiRegistry.addCategory(mainCategory);
            HashMap subCategories = new HashMap();
            if (!tuple.map.getSubCategories().isEmpty()) {
                tuple.map.getSubCategories().forEach((s, subCategory) -> {
                    ResourceLocation subCategoryId = new ResourceLocation("gt", s);
                    EmiRecipeCategory subEmiCategory = new EmiRecipeCategory(subCategoryId, this.createIcon(subCategory.icon().get(), null));
                    subCategories.put(s, subEmiCategory);
                    emiRegistry.addCategory(subEmiCategory);
                });
            }
            tuple.workstations.forEach(s -> {
                Item item = RegistryUtils.getItemFromID(s);
                if (item == Items.f_41852_) {
                    return;
                }
                emiRegistry.addWorkstation(mainCategory, (EmiIngredient)EmiStack.of((ItemLike)item));
                if (!subCategories.isEmpty()) {
                    subCategories.values().forEach(arg_0 -> GTLibEmiPlugin.lambda$register$6(emiRegistry, (ItemLike)item, arg_0));
                }
            });
            if (tuple.map.getSubCategories().isEmpty()) {
                List<IRecipe> recipes = GTLibXEIPlugin.getRecipes(tuple.map, emiRegistry.getRecipeManager());
                recipes.forEach(r -> emiRegistry.addRecipe((EmiRecipe)new RecipeMapRecipe(mainCategory, (IRecipe)r, gui, tier)));
            } else {
                List<IRecipe> recipes = GTLibXEIPlugin.getRecipes(tuple.map, emiRegistry.getRecipeManager());
                ArrayList<IRecipe> mainRecipes = new ArrayList<IRecipe>();
                HashMap<String, List> recipeMap = new HashMap<String, List>();
                for (IRecipe iRecipe : recipes) {
                    boolean found = false;
                    for (Map.Entry<String, SubCategory> entry : tuple.map.getSubCategories().entrySet()) {
                        if (!entry.getValue().predicate().test(iRecipe)) continue;
                        found = true;
                        recipeMap.computeIfAbsent(entry.getKey(), s -> new ArrayList()).add(iRecipe);
                        break;
                    }
                    if (found) continue;
                    mainRecipes.add(iRecipe);
                }
                mainRecipes.forEach(r -> emiRegistry.addRecipe((EmiRecipe)new RecipeMapRecipe(mainCategory, (IRecipe)r, gui, tier)));
                for (Map.Entry entry : recipeMap.entrySet()) {
                    EmiRecipeCategory recipeCategory = (EmiRecipeCategory)subCategories.get(entry.getKey());
                    ((List)entry.getValue()).forEach(r -> emiRegistry.addRecipe((EmiRecipe)new RecipeMapRecipe(recipeCategory, (IRecipe)r, gui, tier)));
                }
            }
        });
    }

    private EmiRenderable createIcon(Object icon, ResourceLocation iconId) {
        EmiStack renderable = EmiStack.of((ItemLike)Data.DEBUG_SCANNER);
        if (icon != null) {
            if (icon instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)icon;
                renderable = EmiStack.of((ItemStack)itemStack);
            }
            if (icon instanceof ItemLike) {
                ItemLike item = (ItemLike)icon;
                renderable = EmiStack.of((ItemLike)item);
            }
            if (icon instanceof ResourceLocation) {
                ResourceLocation resourceLocation = (ResourceLocation)icon;
                renderable = new EmiTexture(resourceLocation, 0, 0, 16, 16, 16, 16, 16, 16);
            }
        } else {
            ScannerItem item;
            ScannerItem scannerItem = item = iconId == null ? Data.DEBUG_SCANNER : RegistryUtils.getItemFromID(iconId);
            if (item == Items.f_41852_) {
                item = Data.DEBUG_SCANNER;
            }
            renderable = EmiStack.of((ItemLike)item);
        }
        return renderable;
    }

    private static /* synthetic */ void lambda$register$6(EmiRegistry emiRegistry, ItemLike item, EmiRecipeCategory c) {
        emiRegistry.addWorkstation(c, (EmiIngredient)EmiStack.of((ItemLike)item));
    }
}

