/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;

public interface ICanSyncData {
    public <T> void bind(Supplier<T> var1, Consumer<T> var2, Function<FriendlyByteBuf, T> var3, BiConsumer<FriendlyByteBuf, T> var4, BiFunction<Object, Object, Boolean> var5, SyncDirection var6);

    default public void syncInt(Supplier<Integer> source, Consumer<Integer> onChange, SyncDirection direction) {
        this.bind(source, onChange, FriendlyByteBuf::m_130242_, FriendlyByteBuf::m_130130_, Object::equals, direction);
    }

    default public void syncLong(Supplier<Long> source, Consumer<Long> onChange, SyncDirection direction) {
        this.bind(source, onChange, FriendlyByteBuf::readLong, FriendlyByteBuf::writeLong, Object::equals, direction);
    }

    default public void syncDouble(Supplier<Double> source, Consumer<Double> onChange, SyncDirection direction) {
        this.bind(source, onChange, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble, Object::equals, direction);
    }

    default public void syncFloat(Supplier<Float> source, Consumer<Float> onChange, SyncDirection direction) {
        this.bind(source, onChange, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat, Object::equals, direction);
    }

    default public void syncString(Supplier<String> source, Consumer<String> onChange, SyncDirection direction) {
        this.bind(source, onChange, a -> a.m_130136_(Short.MAX_VALUE), FriendlyByteBuf::m_130070_, Object::equals, direction);
    }

    default public void syncBoolean(Supplier<Boolean> source, Consumer<Boolean> onChange, SyncDirection direction) {
        this.bind(source, onChange, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean, Object::equals, direction);
    }

    default public void syncFluidStack(Supplier<FluidStack> source, Consumer<FluidStack> onChange, SyncDirection direction) {
        this.bind(() -> ((FluidStack)source.get()).copy(), onChange, IForgeFriendlyByteBuf::readFluidStack, IForgeFriendlyByteBuf::writeFluidStack, (a, b) -> {
            FluidStack f = (FluidStack)a;
            if (!(b instanceof FluidStack)) {
                return false;
            }
            FluidStack h = (FluidStack)b;
            return a.equals(b) && h.getAmount() == f.getAmount();
        }, direction);
    }

    default public void syncItemStack(Supplier<ItemStack> source, Consumer<ItemStack> onChange, SyncDirection direction) {
        this.bind(() -> ((ItemStack)source.get()).m_41777_(), onChange, FriendlyByteBuf::m_130267_, FriendlyByteBuf::m_130055_, Object::equals, direction);
    }

    default public <T extends Enum<T>> void syncEnum(Supplier<T> source, Consumer<T> onChange, Class<T> clazz, SyncDirection direction) {
        this.bind(source, onChange, b -> b.m_130066_(clazz), FriendlyByteBuf::m_130068_, Object::equals, direction);
    }

    public static enum SyncDirection {
        SERVER_TO_CLIENT,
        CLIENT_TO_SERVER;

    }
}

