/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.loading.FMLPaths;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.datagen.GTDynamicPackContents;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;
import org.jetbrains.annotations.Nullable;

public class GTDynamicDataPack
implements PackResources {
    protected static final ObjectSet<String> SERVER_DOMAINS = new ObjectOpenHashSet();
    protected static final GTDynamicPackContents CONTENTS = new GTDynamicPackContents();
    private final String name;

    public GTDynamicDataPack(String name, Collection<String> domains) {
        this.name = name;
    }

    public static void clearServer() {
        CONTENTS.clearData();
        SERVER_DOMAINS.clear();
    }

    private static void addToData(ResourceLocation location, byte[] bytes) {
        CONTENTS.addToData(location, bytes);
        SERVER_DOMAINS.add((Object)location.m_135827_());
    }

    public static void addWorldgenObject(IWorldgenObject<?> object) {
        Path parent = FMLPaths.CONFIGDIR.get().getParent().resolve("dumped/gtlib-dynamic-data/data");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            GTDynamicDataPack.writeJson(object.getLoc(), "gt_worldgen/" + object.getSubDirectory() + "/", parent, object.toJson());
        }
        GTDynamicDataPack.addData(GTDynamicDataPack.getWorldgenLoc(object.getLoc(), object.getSubDirectory()), object.toJson());
    }

    public static void addRecipe(FinishedRecipe recipe) {
        JsonObject recipeJson = recipe.m_125966_();
        Path parent = FMLPaths.CONFIGDIR.get().getParent().resolve("dumped/gtlib-dynamic-data/data");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            GTDynamicDataPack.writeJson(recipe.m_6445_(), "recipes", parent, recipeJson);
        }
        GTDynamicDataPack.addData(GTDynamicDataPack.getRecipeLoc(recipe.m_6445_()), recipeJson);
        if (recipe.m_5860_() != null) {
            JsonObject advancement = recipe.m_5860_();
            if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
                GTDynamicDataPack.writeJson(recipe.m_6448_(), "advancements", parent, advancement);
            }
            GTDynamicDataPack.addData(GTDynamicDataPack.getAdvancementLoc(Objects.requireNonNull(recipe.m_6448_())), advancement);
        }
    }

    private static void writeJson(ResourceLocation id, String subdir, Path parent, JsonObject json) {
        try {
            Path file = parent.resolve(id.m_135827_()).resolve(subdir).resolve(id.m_135815_() + ".json");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(json.toString().getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addAdvancement(ResourceLocation loc, JsonObject obj) {
        ResourceLocation l = GTDynamicDataPack.getAdvancementLoc(loc);
        GTDynamicDataPack.addData(l, obj);
    }

    public static void addData(ResourceLocation loc, JsonObject obj) {
        GTDynamicDataPack.addToData(loc, obj.toString().getBytes());
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        if (elements.length > 0 && elements[0].equals("pack.png")) {
            return () -> GTLib.class.getResourceAsStream("/assets/gtlib/icon.png");
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (type == PackType.SERVER_DATA) {
            return CONTENTS.getResource(location);
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType == PackType.SERVER_DATA) {
            CONTENTS.listResources(namespace, path, resourceOutput);
        }
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.SERVER_DATA ? SERVER_DOMAINS : Set.of();
    }

    public String m_5542_() {
        return this.name;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        String metadataSection = metaReader.m_7991_();
        if (metadataSection.equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)9);
            object.addProperty("description", "runtime data pack");
            return (T)metaReader.m_6322_(object);
        }
        if (metadataSection.equals("filter")) {
            return null;
        }
        return (T)metaReader.m_6322_(new JsonObject());
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    public static ResourceLocation getRecipeLoc(ResourceLocation recipeId) {
        return new ResourceLocation(recipeId.m_135827_(), String.join((CharSequence)"", "recipes/", recipeId.m_135815_(), ".json"));
    }

    public static ResourceLocation getWorldgenLoc(ResourceLocation worldgenId, String subDirectory) {
        return new ResourceLocation(worldgenId.m_135827_(), String.join((CharSequence)"", "gt_worldgen/", subDirectory, "/", worldgenId.m_135815_(), ".json"));
    }

    public static ResourceLocation getAdvancementLoc(ResourceLocation advancementId) {
        return new ResourceLocation(advancementId.m_135827_(), String.join((CharSequence)"", "advancements/", advancementId.m_135815_(), ".json"));
    }

    public static ResourceLocation getTagLoc(String identifier, ResourceLocation tagId) {
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", "tags/", identifier, "/", tagId.m_135815_(), ".json"));
    }
}

