/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.data;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.MaterialSword;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourBlockTilling;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourCropHarvesting;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourExtendedHighlight;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourLogStripping;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourPoweredDebug;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourPumpkinCarving;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourShearing;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourTorchPlacing;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourTreeFelling;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourVanillaShovel;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourWaterlogToggle;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourWrenchSwitching;

public class GTTools {
    public static final GTToolType SWORD = GTAPI.register(GTToolType.class, new GTToolType("gt", "sword", 2, 1, 10, 3.0f, -2.4f, false)).setToolClass(MaterialSword.class).addEffectiveBlocks(Blocks.f_50033_).setHasContainer(false).setMaterialTypeItem(GTMaterialTypes.SWORD_BLADE).setMaterialTypeItemPredicate(m -> !m.has(MaterialTags.FLINT));
    public static final GTToolType PICKAXE = GTAPI.register(GTToolType.class, new GTToolType("gt", "pickaxe", 1, 2, 10, 1.0f, -2.8f, true)).addEffectiveBlocks(Blocks.f_50039_, Blocks.f_50032_).addEffectiveBlockTags(BlockTags.f_13047_).setHasContainer(false).setMaterialTypeItem(GTMaterialTypes.PICKAXE_HEAD).setMaterialTypeItemPredicate(m -> !m.has(MaterialTags.FLINT));
    public static final GTToolType SHOVEL = GTAPI.register(GTToolType.class, new GTToolType("gt", "shovel", 1, 2, 10, 1.5f, -3.0f, true)).setHasContainer(false).setMaterialTypeItem(GTMaterialTypes.SHOVEL_HEAD).setMaterialTypeItemPredicate(m -> !m.has(MaterialTags.FLINT));
    public static final GTToolType AXE = GTAPI.register(GTToolType.class, new GTToolType("gt", "axe", 1, 1, 10, 6.0f, -3.0f, true)).setHasContainer(false).setMaterialTypeItem(GTMaterialTypes.AXE_HEAD).setMaterialTypeItemPredicate(m -> !m.has(MaterialTags.FLINT));
    public static final GTToolType HOE = GTAPI.register(GTToolType.class, new GTToolType("gt", "hoe", 1, 2, 10, -2.0f, -1.0f, true)).setHasContainer(false).setMaterialTypeItem(GTMaterialTypes.HOE_HEAD).setMaterialTypeItemPredicate(m -> !m.has(MaterialTags.FLINT));
    public static final GTToolType HAMMER = GTAPI.register(GTToolType.class, new GTToolType("gt", "hammer", 1, 2, 2, 3.0f, -3.0f, false)).addTags("pickaxe").setUseSound(SoundEvents.f_11669_).setRepairable(false).setMaterialTypeItem(GTMaterialTypes.HAMMER_HEAD);
    public static final GTToolType WRENCH = GTAPI.register(GTToolType.class, new GTToolType("gt", "wrench", 1, 2, 2, 1.5f, -2.8f, false)).setUseSound(Ref.WRENCH).addEffectiveBlocks(Blocks.f_50332_).setHasSecondary(false).setOverlayLayers(0).setRepairable(false).addBlacklistedEnchantments(Enchantments.f_44984_);
    public static final GTToolType WRENCH_ALT = GTAPI.register(GTToolType.class, new GTToolType("gt", "wrench_alt", 1, 2, 2, 1.5f, -2.8f, false)).setUseSound(Ref.WRENCH).addEffectiveBlocks(Blocks.f_50332_).addTags("wrench").setHasSecondary(false).setOverlayLayers(0).setRepairable(false).addBlacklistedEnchantments(Enchantments.f_44984_).setCustomName("Wrench (Alt)");
    public static final GTToolType SAW = GTAPI.register(GTToolType.class, new GTToolType("gt", "saw", 1, 2, 2, 2.0f, -2.8f, false)).addEffectiveBlocks(Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_).setRepairable(false).setMaterialTypeItem(GTMaterialTypes.SAW_BLADE).addTags("axe");
    public static final GTToolType FILE = GTAPI.register(GTToolType.class, new GTToolType("gt", "file", 1, 2, 2, -2.0f, -2.4f, false)).setRepairable(false).setMaterialTypeItem(GTMaterialTypes.FILE_HEAD);
    public static final GTToolType CROWBAR = GTAPI.register(GTToolType.class, new GTToolType("gt", "crowbar", 1, 10, 5, 1.0f, -2.0f, false)).setUseSound(SoundEvents.f_12018_).setHasSecondary(false).setRepairable(false);
    public static final GTToolType SOFT_HAMMER = GTAPI.register(GTToolType.class, new GTToolType("gt", "soft_hammer", 1, 2, 2, 1.0f, -3.0f, false)).setRepairable(false).setPrimaryRequirement(MaterialTags.RUBBERTOOLS);
    public static final GTToolType SCREWDRIVER = GTAPI.register(GTToolType.class, new GTToolType("gt", "screwdriver", 1, 2, 2, 0.0f, -1.0f, false)).setUseSound(Ref.WRENCH).setRepairable(false).setMaterialTypeItem(GTMaterialTypes.SCREWDRIVER_TIP);
    public static final GTToolType WIRE_CUTTER = GTAPI.register(GTToolType.class, new GTToolType("gt", "wire_cutter", 1, 3, 2, 0.0f, -1.5f, false)).setUseSound(Ref.WIRE_CUTTERS).setRepairable(false).addBlacklistedEnchantments(Enchantments.f_44984_);
    public static final GTToolType BRANCH_CUTTER = GTAPI.register(GTToolType.class, new GTToolType("gt", "branch_cutter", 1, 3, 2, 0.0f, -1.5f, false)).addTags("grafter").setHasContainer(false).setDurabilityMultiplier(0.25f);
    public static final GTToolType KNIFE = GTAPI.register(GTToolType.class, new GTToolType("gt", "knife", 1, 2, 1, 2.1f, -2.0f, false)).addEffectiveBlocks(Blocks.f_50033_).setRepairable(false).setMaterialTypeItem(GTMaterialTypes.KNIFE_BLADE).setTag(new ResourceLocation("gtlib", "knives")).setOriginalTag(true);
    public static final GTToolType SCISSORS = GTAPI.register(GTToolType.class, new GTToolType("gt", "scissors", 1, 2, 2, 1.0f, -1.5f, false));
    public static final GTToolType PLUNGER = GTAPI.register(GTToolType.class, new GTToolType("gt", "plunger", 5, 5, 10, 0.0f, -2.9f, false)).setUseSound(SoundEvents.f_11778_).setHasSecondary(false).setRepairable(false);
    public static final GTToolType SCYTHE = GTAPI.register(GTToolType.class, new GTToolType("gt", "scythe", 1, 2, 5, 6.5f, -3.1f, false)).setMaterialTypeItem(GTMaterialTypes.SCYTHE_BLADE);
    public static final GTArmorType HELMET = new GTArmorType("gt", "helmet", 40, 0, 0.0f, 0.0f, ArmorItem.Type.HELMET);
    public static final GTArmorType CHESTPLATE = new GTArmorType("gt", "chestplate", 40, 0, 0.0f, 0.0f, ArmorItem.Type.CHESTPLATE);
    public static final GTArmorType LEGGINGS = new GTArmorType("gt", "leggings", 40, 0, 0.0f, 0.0f, ArmorItem.Type.LEGGINGS);
    public static final GTArmorType BOOTS = new GTArmorType("gt", "boots", 40, 0, 0.0f, 0.0f, ArmorItem.Type.BOOTS);

    public static void init(Dist side) {
        AXE.addBehaviour(BehaviourLogStripping.INSTANCE, BehaviourTreeFelling.INSTANCE);
        PICKAXE.addBehaviour(BehaviourTorchPlacing.INSTANCE);
        PLUNGER.addBehaviour(BehaviourWaterlogToggle.INSTANCE);
        WRENCH.addBehaviour(BehaviourWrenchSwitching.INSTANCE);
        WRENCH_ALT.addBehaviour(BehaviourWrenchSwitching.INSTANCE);
        KNIFE.addBehaviour(BehaviourPumpkinCarving.INSTANCE);
        SCISSORS.addBehaviour(BehaviourShearing.INSTANCE);
        SCYTHE.addBehaviour(BehaviourCropHarvesting.INSTANCE);
        if (side == Dist.CLIENT) {
            GTTools.clientInit();
        }
        PICKAXE.addReplacement(GTLibMaterials.Iron, () -> Items.f_42385_);
        PICKAXE.addReplacement(GTLibMaterials.Gold, () -> Items.f_42432_);
        PICKAXE.addReplacement(GTLibMaterials.Diamond, () -> Items.f_42390_);
        AXE.addReplacement(GTLibMaterials.Iron, () -> Items.f_42386_);
        AXE.addReplacement(GTLibMaterials.Gold, () -> Items.f_42433_);
        AXE.addReplacement(GTLibMaterials.Diamond, () -> Items.f_42391_);
        SHOVEL.addReplacement(GTLibMaterials.Iron, () -> Items.f_42384_);
        SHOVEL.addReplacement(GTLibMaterials.Gold, () -> Items.f_42431_);
        SHOVEL.addReplacement(GTLibMaterials.Diamond, () -> Items.f_42389_);
        SWORD.addReplacement(GTLibMaterials.Iron, () -> Items.f_42383_);
        SWORD.addReplacement(GTLibMaterials.Gold, () -> Items.f_42430_);
        SWORD.addReplacement(GTLibMaterials.Diamond, () -> Items.f_42388_);
        HOE.addReplacement(GTLibMaterials.Iron, () -> Items.f_42387_);
        HOE.addReplacement(GTLibMaterials.Gold, () -> Items.f_42434_);
        HOE.addReplacement(GTLibMaterials.Diamond, () -> Items.f_42392_);
    }

    public static void postInit() {
        for (GTToolType type : GTAPI.all(GTToolType.class)) {
            if (type.getToolTypes().contains(BlockTags.f_144283_)) {
                type.addBehaviour(BehaviourVanillaShovel.INSTANCE);
            }
            if (type.getToolTypes().contains(BlockTags.f_144281_)) {
                type.addBehaviour(BehaviourBlockTilling.INSTANCE);
            }
            if (!type.isPowered()) continue;
            type.addBehaviour(BehaviourPoweredDebug.INSTANCE);
        }
    }

    private static void clientInit() {
        WRENCH.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(WRENCH.getToolType()) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61373_) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61374_), BehaviourExtendedHighlight.PIPE_FUNCTION));
        WRENCH_ALT.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(WRENCH.getToolType()) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61373_) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61374_), BehaviourExtendedHighlight.PIPE_FUNCTION));
        SCREWDRIVER.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION));
        WIRE_CUTTER.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockPipe && b.m_204297_().m_203656_(WIRE_CUTTER.getToolType()), BehaviourExtendedHighlight.PIPE_FUNCTION));
        CROWBAR.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION));
    }
}

