/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.FakeTrackedItemHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.cover.ICoverModeHandler;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.slot.ISlotProvider;
import org.gtreimagined.gtlib.gui.widget.BackgroundWidget;
import org.gtreimagined.gtlib.gui.widget.CoverModeHandlerWidget;
import org.gtreimagined.gtlib.gui.widget.SlotWidget;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.network.packets.CoverGuiEventPacket;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCover
implements ICover,
IGuiHandler.IHaveWidgets {
    @NotNull
    public final CoverFactory factory;
    @NotNull
    public final ICoverHandler<?> handler;
    @Nullable
    public final Tier tier;
    @Nullable
    public final GuiData gui;
    public final Direction side;
    private final List<Consumer<GuiInstance>> guiCallbacks = new ObjectArrayList();
    protected Object2ObjectMap<SlotType<?>, TrackedItemHandler<?>> inventories = null;

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return new ResourceLocation(this.getDomain() + ":block/cover/" + this.getRenderId());
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public ICoverHandler<?> source() {
        return this.handler;
    }

    public BaseCover(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        this.factory = Objects.requireNonNull(factory, "Missing factory in BaseCover");
        this.handler = source;
        this.tier = tier;
        this.side = side;
        if (factory.hasGui()) {
            this.gui = new GuiData(this, factory.getMenuHandler());
            this.gui.setEnablePlayerSlots(true);
            this.gui.setSlots(ISlotProvider.DEFAULT());
            this.addGuiCallback(t -> {
                t.addWidget(BackgroundWidget.build(t.handler.getGuiTexture(), t.handler.guiSize(), t.handler.guiHeight(), t.handler.guiTextureSize(), t.handler.guiTextureHeight()));
                if (this instanceof ICoverModeHandler) {
                    t.addWidget(CoverModeHandlerWidget.build());
                }
                List<SlotData<?>> slots = tier == null ? this.gui.getSlots().getAnySlots() : this.gui.getSlots().getSlots(tier);
                slots.forEach(s -> t.addWidget(SlotWidget.build(s)));
            });
        } else {
            this.gui = null;
        }
    }

    @Override
    public void onPlace() {
        this.onCreate();
    }

    @Override
    public void onCreate() {
        this.setInventory();
    }

    private void setInventory() {
        if (this.factory.hasGui()) {
            if (this.inventories == null) {
                this.inventories = new Object2ObjectOpenHashMap();
            }
            List<SlotData<?>> slots = this.tier == null ? this.gui.getSlots().getAnySlots() : this.gui.getSlots().getSlots(this.tier);
            Map<SlotType, List<SlotData>> map = slots.stream().collect(Collectors.groupingBy(SlotData::getType));
            slots.forEach(s -> {
                for (Map.Entry entry : map.entrySet()) {
                    SlotType type = (SlotType)entry.getKey();
                    int count = this.gui.getSlots().getCount(this.tier, (SlotType)entry.getKey());
                    if (type == SlotType.DISPLAY_SETTABLE || type == SlotType.DISPLAY) {
                        this.inventories.put((Object)type, new FakeTrackedItemHandler<BaseCover>(this, type, count, type.output, type.input, type.tester));
                        continue;
                    }
                    this.inventories.put((Object)type, new TrackedItemHandler<BaseCover>(this, type, count, type.output, type.input, type.tester));
                }
            });
        }
    }

    @Override
    @Nullable
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public List<Consumer<GuiInstance>> getCallbacks() {
        return this.guiCallbacks;
    }

    @Override
    public Map<SlotType<?>, IItemHandler> getAll() {
        return (Map)this.inventories;
    }

    public ITrackedHandler getInventory(SlotType<?> type) {
        return (ITrackedHandler)this.inventories.get(type);
    }

    @Override
    public void deserializeStack(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128441_("coverInventories")) {
            CompoundTag nbt = tag.m_128469_("coverInventories");
            if (this.inventories != null && this.getFactory().hasGui()) {
                this.inventories.forEach((f, i) -> {
                    if (!nbt.m_128441_(f.getId())) {
                        return;
                    }
                    i.deserializeNBT(nbt.m_128469_(f.getId()));
                });
                this.handler.getTile().m_6596_();
            }
        }
    }

    @Override
    public CompoundTag serializeStack(CompoundTag tag) {
        if (this.inventories != null && this.getFactory().hasGui()) {
            CompoundTag nbt = new CompoundTag();
            this.inventories.forEach((f, i) -> {
                if (i.isEmpty()) {
                    return;
                }
                nbt.m_128365_(f.getId(), (Tag)i.serializeNBT());
            });
            if (!nbt.m_128456_()) {
                tag.m_128365_("coverInventories", (Tag)nbt);
            }
        }
        return tag;
    }

    @Override
    public void setTextures(BiConsumer<String, Texture> texer) {
        texer.accept("overlay", this.factory.getTextures().isEmpty() ? new Texture(this.factory.getDomain(), "block/cover/" + this.getRenderId()) : this.factory.getTextures().get(this.factory.getTextures().size() == 6 ? this.side.m_122411_() : 0));
    }

    @Override
    public Texture[] getTextures() {
        ArrayList l = new ArrayList();
        this.setTextures((name, tex) -> l.add(tex));
        return l.toArray(new Texture[0]);
    }

    protected String getRenderId() {
        return this.getId();
    }

    public static ResourceLocation getBasicModel() {
        return new ResourceLocation("gtlib:block/cover/basic");
    }

    public static ResourceLocation getBasicDepthModel() {
        return new ResourceLocation("gtlib:block/cover/basic_depth");
    }

    @Override
    public ItemStack getItem() {
        return this.factory.getItem(this.tier);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (this.getFactory().hasGui()) {
            this.inventories.forEach((f, i) -> {
                if (!nbt.m_128441_(f.getId())) {
                    return;
                }
                i.deserializeNBT(nbt.m_128469_(f.getId()));
            });
        }
    }

    @Override
    public boolean hasGui() {
        return this.factory.hasGui();
    }

    @Override
    public GuiData getGui() {
        return this.gui;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        if (this.inventories != null && this.getFactory().hasGui()) {
            this.inventories.forEach((f, i) -> {
                if (i.isEmpty()) {
                    return;
                }
                nbt.m_128365_(f.getId(), (Tag)i.serializeNBT());
            });
        }
        return nbt;
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        return this.hasGui() ? (AbstractContainerMenu)this.getGui().getMenuHandler().menu(this, p_createMenu_3_.m_150109_(), p_createMenu_1_) : null;
    }

    @Override
    public boolean isRemote() {
        return this.handler.getTile().m_58904_().m_5776_();
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation("gtlib", "textures/gui/background/machine_basic.png");
    }

    @Override
    public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
        return new CoverGuiEventPacket(event, this.handler.getTile().m_58899_(), this.side);
    }

    @Override
    public CoverFactory getFactory() {
        return this.factory;
    }

    protected void markAndNotifySource() {
        this.source().getTile().m_58904_().markAndNotifyBlock(this.source().getTile().m_58899_(), this.source().getTile().m_58904_().m_46745_(this.source().getTile().m_58899_()), this.source().getTile().m_58900_(), this.source().getTile().m_58900_(), 1, 512);
    }
}

