/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.gtreimagined.gtlib.client.model.IModelBuilder;
import org.gtreimagined.gtlib.client.model.ISimpleModel;
import org.gtreimagined.gtlib.client.model.loader.IGTModelLoader;
import org.gtreimagined.gtlib.mixin.client.BlockModelAccessor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class VanillaProxy
implements ISimpleModel<VanillaProxy> {
    private final List<BlockElement> elements;

    public VanillaProxy(List<BlockElement> list) {
        this.elements = list;
    }

    @Override
    public void addQuads(IGeometryBakingContext owner, IModelBuilder<?> modelBuilder, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        for (BlockElement blockpart : this.elements) {
            for (Direction direction : blockpart.f_111310_.keySet()) {
                BlockElementFace blockpartface = (BlockElementFace)blockpart.f_111310_.get(direction);
                TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(owner.getMaterial(blockpartface.f_111356_));
                if (blockpartface.f_111354_ == null) {
                    modelBuilder.addGeneralQuad(BlockModelAccessor.invokeBakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
                    continue;
                }
                modelBuilder.addFaceQuad(Direction.m_252919_((Matrix4f)modelTransform.m_6189_().m_252783_(), (Direction)blockpartface.f_111354_), BlockModelAccessor.invokeBakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
            }
        }
    }

    public static class Loader
    implements IGTModelLoader<VanillaProxy> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @NotNull
        public VanillaProxy read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            List<BlockElement> list = this.getModelElements(deserializationContext, modelContents);
            return new VanillaProxy(list);
        }

        private List<BlockElement> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)object, (String)"elements")) {
                    list.add((BlockElement)deserializationContext.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return "vanilla_proxy";
        }
    }
}

