/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.baked;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.gtreimagined.gtlib.client.GTLibModelProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGTBakedModel
extends IDynamicBakedModel {
    public List<BakedQuad> getBlockQuads(BlockState var1, @Nullable Direction var2, @NotNull RandomSource var3, @NotNull BlockAndTintGetter var4, @NotNull BlockPos var5);

    default public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        try {
            if (this.hasOnlyGeneralQuads() && side != null) {
                return Collections.emptyList();
            }
            return state != null ? this.getBlockQuads(state, side, rand, level, pos) : Collections.emptyList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public boolean hasOnlyGeneralQuads();

    default public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return Collections.emptyList();
    }

    @NotNull
    default public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.get(GTLibModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.get(GTLibModelProperties.POS);
        if (world == null || pos == null) {
            return Collections.emptyList();
        }
        return this.getQuads(state, side, rand, world, pos);
    }

    @NotNull
    default public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        ModelData d = super.getModelData(level, pos, state, modelData);
        ModelData.Builder builder = null;
        if (d == ModelData.EMPTY) {
            builder = ModelData.builder();
        }
        if (builder != null) {
            builder.with(GTLibModelProperties.WORLD, (Object)level);
            builder.with(GTLibModelProperties.POS, (Object)pos);
            d = builder.build();
        }
        return d;
    }

    default public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.get(GTLibModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.get(GTLibModelProperties.POS);
        if (world == null || pos == null) {
            return super.getParticleIcon(data);
        }
        return this.getParticleIcon(world, pos);
    }

    public TextureAtlasSprite getParticleIcon(BlockAndTintGetter var1, BlockPos var2);
}

