/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.client.baked.PipeFullBakedModel;
import org.gtreimagined.gtlib.client.model.loader.DefaultModelLoader;
import org.gtreimagined.gtlib.client.model.loader.DynamicModelLoader;
import org.gtreimagined.gtlib.client.model.loader.MachineModelLoader;
import org.gtreimagined.gtlib.client.model.loader.PipeFullModelLoader;
import org.gtreimagined.gtlib.client.model.loader.PipeModelLoader;
import org.gtreimagined.gtlib.client.model.loader.ProxyModelLoader;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GTLibModelManager {
    private static final Object2ObjectOpenHashMap<String, Supplier<Int2ObjectOpenHashMap<BakedModel[]>>> STATIC_CONFIG_MAPS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<ResourceLocation, IItemProviderOverride> ITEM_OVERRIDES = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<ResourceLocation, IBlockProviderOverride> BLOCK_OVERRIDES = new Object2ObjectOpenHashMap();
    public static final ResourceLocation LOADER_MAIN = new ResourceLocation("gtlib", "main");
    public static final ResourceLocation LOADER_COVER = new ResourceLocation("gtlib", "cover");
    public static final ResourceLocation LOADER_MACHINE_SIDE = new ResourceLocation("gtlib", "machine_side");
    public static final ResourceLocation LOADER_DYNAMIC = new ResourceLocation("gtlib", "dynamic");
    public static final ResourceLocation LOADER_MACHINE = new ResourceLocation("gtlib", "machine");
    public static final ResourceLocation LOADER_PIPE_FULL = new ResourceLocation("gtlib", "pipe_full");
    public static final ResourceLocation LOADER_PIPE = new ResourceLocation("gtlib", "pipe");
    public static final ResourceLocation LOADER_PROXY = new ResourceLocation("gtlib", "proxy");

    public static void init() {
        GTLibModelManager.registerStaticConfigMap("pipe", () -> PipeFullBakedModel.CONFIGS);
        new DefaultModelLoader(LOADER_MAIN);
        new MachineModelLoader.CoverModelLoader(LOADER_COVER);
        new MachineModelLoader.SideModelLoader(LOADER_MACHINE_SIDE);
        new DynamicModelLoader(LOADER_DYNAMIC);
        new MachineModelLoader(LOADER_MACHINE);
        new PipeFullModelLoader(LOADER_PIPE_FULL);
        new PipeModelLoader(LOADER_PIPE);
        new ProxyModelLoader(LOADER_PROXY);
    }

    public static void registerStaticConfigMap(String staticMapId, Supplier<Int2ObjectOpenHashMap<BakedModel[]>> configMapSupplier) {
        STATIC_CONFIG_MAPS.put((Object)staticMapId, configMapSupplier);
    }

    public static Int2ObjectOpenHashMap<BakedModel[]> getStaticConfigMap(String staticMapId) {
        return (Int2ObjectOpenHashMap)((Supplier)STATIC_CONFIG_MAPS.getOrDefault((Object)staticMapId, Int2ObjectOpenHashMap::new)).get();
    }

    public static void put(Item item, IItemProviderOverride override) {
        ITEM_OVERRIDES.put((Object)RegistryUtils.getIdFromItem(item), (Object)override);
    }

    public static void put(Block block, IBlockProviderOverride override) {
        BLOCK_OVERRIDES.put((Object)RegistryUtils.getIdFromBlock(block), (Object)override);
    }

    public static void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        IItemProviderOverride override = (IItemProviderOverride)ITEM_OVERRIDES.get((Object)RegistryUtils.getIdFromItem(item.m_5456_()));
        if (override != null) {
            override.apply((ItemLike)item.m_5456_(), prov);
        } else if (item instanceof IModelProvider) {
            ((IModelProvider)item).onItemModelBuild(item, prov);
        }
    }

    public static void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        IBlockProviderOverride override = (IBlockProviderOverride)BLOCK_OVERRIDES.get((Object)RegistryUtils.getIdFromBlock(block));
        if (override != null) {
            override.apply(block, prov, prov.getBuilder(block));
        } else if (block instanceof IModelProvider) {
            ((IModelProvider)block).onBlockModelBuild(block, prov);
        }
    }

    public static interface IItemProviderOverride {
        public void apply(ItemLike var1, GTItemModelProvider var2);
    }

    public static interface IBlockProviderOverride {
        public void apply(Block var1, GTBlockStateProvider var2, GTBlockModelBuilder var3);
    }
}

