/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturer;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturers;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverHandler<T extends BlockEntity>
implements ICoverHandler<T> {
    private final T tile;
    protected final Object2ObjectMap<Direction, ICover> covers = new Object2ObjectOpenHashMap(6);
    protected final Object2ObjectMap<CoverFactory, Set<Direction>> reverseLookup = new Object2ObjectOpenHashMap(6);
    protected Set<ResourceLocation> validCovers = new ObjectOpenHashSet();
    public final Map<Direction, DynamicTexturer<ICover, ICover.DynamicKey>> coverTexturer;

    public CoverHandler(T tile, CoverFactory ... validCovers) {
        this.tile = tile;
        this.validCovers.add(new ResourceLocation(ICover.empty.getDomain(), ICover.empty.getId()));
        Arrays.stream(validCovers).forEach(c -> this.validCovers.add(new ResourceLocation(c.getDomain(), c.getId())));
        Arrays.stream(Ref.DIRS).forEach(t -> this.set((Direction)t, ICover.empty, false));
        this.coverTexturer = new EnumMap<Direction, DynamicTexturer<ICover, ICover.DynamicKey>>(Direction.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DynamicTexturer<ICover, ICover.DynamicKey> getTexturer(Direction dir) {
        return this.coverTexturer.computeIfAbsent(dir, d -> new DynamicTexturer<ICover, ICover.DynamicKey>(DynamicTexturers.COVER_DYNAMIC_TEXTURER));
    }

    @Override
    public boolean set(Direction side, @NotNull ICover newCover, boolean sync) {
        if (!this.validCovers.contains(newCover.getLoc())) {
            return false;
        }
        ICover old = (ICover)this.covers.getOrDefault((Object)side, (Object)ICover.empty);
        return this.set(side, old, newCover, sync);
    }

    public boolean set(Direction side, ICover old, ICover stack, boolean sync) {
        if (!stack.canPlace()) {
            return false;
        }
        this.covers.put((Object)side, (Object)stack);
        this.buildLookup(old.getFactory(), stack.getFactory(), side);
        old.onRemove();
        stack.onPlace();
        if (this.tile.m_58904_() != null && sync) {
            this.sync();
        }
        return true;
    }

    protected void sync() {
        Level world = this.tile.m_58904_();
        if (world == null) {
            return;
        }
        if (!world.f_46443_) {
            this.tile.m_6596_();
            Utils.markTileForNBTSync(this.tile);
        } else {
            Utils.markTileForRenderUpdate(this.tile);
        }
        this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void buildLookup(CoverFactory oldCover, CoverFactory newCover, Direction dir) {
        Set set = (Set)this.reverseLookup.compute((Object)oldCover, (k, v) -> {
            if (v == null) {
                v = new ObjectOpenHashSet();
            }
            v.remove(dir);
            return v;
        });
        this.reverseLookup.compute((Object)newCover, (k, v) -> {
            if (v == null) {
                v = new ObjectOpenHashSet();
            }
            v.add(dir);
            return v;
        });
        if (set.isEmpty()) {
            this.reverseLookup.remove((Object)oldCover);
        }
    }

    public Set<Direction> lookup(CoverFactory c) {
        return (Set)this.reverseLookup.get((Object)c);
    }

    @Nullable
    public Direction lookupSingle(CoverFactory c) {
        Set set = (Set)this.reverseLookup.get((Object)c);
        if (set != null && set.size() == 1) {
            return (Direction)set.iterator().next();
        }
        return null;
    }

    @Override
    @NotNull
    public ICover get(Direction side) {
        return (ICover)this.covers.getOrDefault((Object)side, (Object)ICover.empty);
    }

    @Override
    public ICover[] getAll() {
        ICover[] ret = new ICover[6];
        for (Direction dir : Ref.DIRS) {
            ret[dir.m_122411_()] = this.get(dir);
        }
        return ret;
    }

    public ICover[] getAllRendered() {
        return this.getAll();
    }

    @Override
    public T getTile() {
        if (this.tile == null) {
            throw new NullPointerException("CoverHandler cannot have a null tile");
        }
        return this.tile;
    }

    @Override
    public void onUpdate() {
        this.covers.forEach((s, c) -> {
            if (c.ticks()) {
                c.onUpdate();
            }
        });
    }

    @Override
    public void onFirstTick() {
        this.covers.forEach((s, c) -> c.onFirstTick());
    }

    public void onBlockUpdate(Direction side) {
        this.get(side).onBlockUpdate();
    }

    public void onBlockUpdateAllSides() {
        this.getCovers().forEach((d, c) -> c.onBlockUpdateAllSides());
    }

    @Override
    public void onRemove() {
        this.covers.forEach((s, c) -> c.onRemove());
    }

    @Override
    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        return ((ICover)this.covers.get((Object)side)).onInteract(player, hand, side, type);
    }

    public boolean onTransfer(Object obj, Direction side, boolean inputSide, boolean simulate) {
        return this.get(side).onTransfer(obj, inputSide, simulate);
    }

    @Override
    public boolean placeCover(Player player, Direction side, ItemStack stack, ICover cover) {
        if (!this.get(side).isEmpty() || !this.set(side, cover, true)) {
            return false;
        }
        cover.addInfoFromStack(stack);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return true;
    }

    @Override
    public boolean removeCover(Player player, Direction side, boolean onlyRemove) {
        ItemStack dropped;
        ICover oldCover = this.get(side);
        if (this.get(side).isEmpty() || !this.set(side, ICover.empty, !onlyRemove)) {
            return false;
        }
        if (!(onlyRemove || player == null || player.m_7500_() || player.m_36356_(dropped = oldCover.getDroppedStack()))) {
            player.m_36176_(dropped, false);
        }
        if (player != null) {
            if (Utils.getToolType(player) != GTTools.WRENCH && Utils.getToolType(player) != GTTools.WRENCH_ALT) {
                player.m_9236_().m_5594_(null, this.tile.m_58899_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                player.m_9236_().m_5594_(null, this.tile.m_58899_(), Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public boolean hasCover(CoverFactory coverFactory) {
        return this.reverseLookup.containsKey((Object)coverFactory);
    }

    @Override
    public boolean isValid(@NotNull Direction side, @NotNull ICover replacement) {
        return (this.get(side).isEmpty() || replacement.isEqual(ICover.empty)) && this.validCovers.contains(replacement.getId());
    }

    public CompoundTag serialize(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        byte[] sides = new byte[1];
        this.covers.forEach((s, c) -> {
            if (!c.isEmpty()) {
                sides[0] = (byte)(sides[0] | 1 << s.m_122411_());
                CoverFactory.writeCover(tag, c, c.side(), false);
            }
        });
        tag.m_128344_("vs", sides[0]);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        byte sides = nbt.m_128445_("vs");
        for (int i = 0; i < Ref.DIRS.length; ++i) {
            if ((sides & 1 << i) > 0) {
                ICover cover = CoverFactory.readCover(this, Direction.m_122376_((int)i), nbt, false);
                if (cover == null) {
                    GTLib.LOGGER.warn(nbt + "at d: " + Direction.m_122376_((int)i) + "at pos: " + this.tile.m_58899_());
                    cover = ICover.empty;
                }
                this.buildLookup(((ICover)this.covers.get((Object)Ref.DIRS[i])).getFactory(), cover.getFactory(), Ref.DIRS[i]);
                this.covers.put((Object)Ref.DIRS[i], (Object)cover);
                continue;
            }
            this.buildLookup(((ICover)this.covers.get((Object)Ref.DIRS[i])).getFactory(), ICover.emptyFactory, Ref.DIRS[i]);
            this.covers.put((Object)Ref.DIRS[i], (Object)ICover.empty);
        }
        Level w = this.tile.m_58904_();
        if (w != null && w.f_46443_) {
            Utils.markTileForRenderUpdate(this.tile);
        }
    }

    public void writeToStack(ItemStack machine) {
    }

    public void readFromStack(ItemStack stack) {
    }

    @Override
    public boolean moveCover(Player entity, Direction oldSide, Direction newSide) {
        ICover newStack = this.get(newSide);
        ICover oldStack = this.get(oldSide);
        if (!newStack.isEmpty() || oldStack.isEmpty()) {
            return false;
        }
        if (!this.removeCover(entity, oldSide, true)) {
            return false;
        }
        CoverFactory factory = oldStack.getFactory();
        ICover copy = factory.get().get(this, oldStack.getTier(), newSide, factory);
        copy.deserialize(oldStack.serialize());
        boolean ok = this.set(newSide, newStack, copy, true);
        if (ok) {
            this.sync();
        }
        return ok;
    }

    public <U> boolean blocksCapability(Class<U> capability, Direction side) {
        ICover stack = this.get(side);
        return stack.blocksCapability(capability, side);
    }

    public <U> boolean blocksInput(Class<U> cap, @Nullable Direction side) {
        ICover stack = this.get(side);
        return stack.blocksInput(cap, side);
    }

    public <U> boolean blocksOutput(Class<U> cap, @Nullable Direction side) {
        ICover stack = this.get(side);
        return stack.blocksOutput(cap, side);
    }

    public List<ItemStack> getDrops() {
        return this.covers.values().stream().map(ICover::getDroppedStack).filter(droppedStack -> !droppedStack.m_41619_()).collect(Collectors.toList());
    }

    @Generated
    public Object2ObjectMap<Direction, ICover> getCovers() {
        return this.covers;
    }
}

