package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.event.SlotClickEvent;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

import java.util.ArrayList;
import java.util.List;

import static org.gtreimagined.gtlib.gui.ICanSyncData.SyncDirection.SERVER_TO_CLIENT;

public class FluidSlotWidget extends Widget {

    private final int slot;
    private final SlotData<?> slots;
    private FluidStack stack = FluidStack.EMPTY;

    protected FluidSlotWidget(GuiInstance gui, IGuiElement parent, int fluidSlot, SlotData<?> slots) {
        super(gui, parent);
        this.slot = fluidSlot;
        this.slots = slots;
        setX(slots.getX());
        setY(slots.getY());
        setW(16);
        setH(16);
    }

    public static WidgetSupplier build(int slot, SlotData<?> slots) {
        return builder((a, b) -> new FluidSlotWidget(a, b, slot, slots));
    }

    @Override
    public void init() {
        super.init();
        if (this.gui.handler instanceof BlockEntityMachine<?> blockEntity){
            this.gui.syncFluidStack(() -> blockEntity.fluidHandler
                    .map(t -> t.getFluidInTank(slot)).orElse(FluidStack.EMPTY), stack -> this.stack = stack, SERVER_TO_CLIENT);
        }

    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        renderFluid(graphics, this.stack, realX(), realY());
    }

    @OnlyIn(Dist.CLIENT)
    public void renderFluid(GuiGraphics graphics, FluidStack fluid, int x, int y) {
        if (fluid.isEmpty())
            return;
        RenderHelper.drawFluid(graphics.pose(), Minecraft.getInstance(), x, y, getW(), getH(), 16, fluid);
    }

    @Override
    public void mouseOver(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(graphics, mouseX, mouseY, partialTicks);
        if (this.stack.isEmpty())
            return;
        int x = realX();
        int y = realY();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask(true, true, true, false);
        int slotColor = -2130706433;
        this.fillGradient(graphics, x, y, 16, 16, slotColor, slotColor);
        RenderSystem.colorMask(true, true, true, true);
        RenderSystem.enableDepthTest();
        List<Component> str = new ArrayList<>();
        str.add(FluidUtils.getFluidDisplayName(this.stack));
        int mb = this.stack.getAmount();
        str.add(Utils.translatable("gtlib.tooltip.fluid.amount", mb + " L").withStyle(ChatFormatting.BLUE));
        str.add(Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(this.stack.getFluid())).withStyle(ChatFormatting.RED));
        String liquid = !FluidUtils.isFluidGaseous(this.stack.getFluid()) ? "liquid" : "gas";
        str.add(Utils.translatable("gtlib.tooltip.fluid." + liquid).withStyle(ChatFormatting.GREEN));
        GTLibXEIPlugin.addModDescriptor(str, this.stack);
        drawHoverText(graphics, str, (int) mouseX, (int) mouseY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        if (!isInside(mouseX, mouseY))
            return super.keyPressed(keyCode, scanCode, modifiers, mouseX, mouseY);
        InputConstants.Key input = InputConstants.getKey(keyCode, scanCode);
        if (!(input.getName().equals("key.keyboard.u") || input.getName().equals("key.keyboard.r")))
            return false;
        GTLibXEIPlugin.uses(stack, input.getName().equals("key.keyboard.u"));
        return true;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        AbstractGuiEventPacket pkt = gui.handler.createGuiPacket(new SlotClickEvent(this.slot, this.slots.getType()));
        gui.sendPacket(pkt);
    }
}
