/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.armor;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.gtreimagined.gtlib.util.TagUtils;

public class MatArmorMaterial
implements ArmorMaterial {
    final GTArmorType type;
    final Material material;
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public MatArmorMaterial(GTArmorType type, Material material) {
        this.type = type;
        this.material = material;
    }

    public int m_266425_(ArmorItem.Type type) {
        return MAX_DAMAGE_ARRAY[type.ordinal()] * MaterialTags.ARMOR.get(this.material).armorDurabilityFactor();
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.type.getExtraArmor() + MaterialTags.ARMOR.get(this.material).armor()[type.ordinal()];
    }

    public int m_6646_() {
        return ArmorMaterials.IRON.m_6646_();
    }

    public SoundEvent m_7344_() {
        return this.type.getEvent();
    }

    public Ingredient m_6230_() {
        if (this.material == null) {
            return Ingredient.f_43901_;
        }
        if (this.material.has(GTMaterialTypes.GEM)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("gems/".concat(this.material.getId())));
        }
        if (this.material.has(GTMaterialTypes.INGOT)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("ingots/".concat(this.material.getId())));
        }
        if (this.material.has(GTMaterialTypes.DUST)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("dusts/".concat(this.material.getId())));
        }
        return Ingredient.f_43901_;
    }

    public String m_6082_() {
        return this.material.getId() + "_" + this.type.getId();
    }

    public float m_6651_() {
        return this.type.getExtraToughness() + MaterialTags.ARMOR.get(this.material).toughness();
    }

    public float m_6649_() {
        return this.type.getExtraKnockback() + MaterialTags.ARMOR.get(this.material).knockbackResistance();
    }
}

