/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class IngredientSerializer
implements IIngredientSerializer<RecipeIngredient> {
    public static final IngredientSerializer INSTANCE = new IngredientSerializer();

    public static void init() {
        GTAPI.register(IIngredientSerializer.class, "ingredient", "gtlib", INSTANCE);
    }

    public RecipeIngredient parse(FriendlyByteBuf buffer) {
        int len = buffer.m_130242_();
        ItemStack[] items = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            items[i] = buffer.m_130267_();
        }
        RecipeIngredient r = RecipeIngredient.of(items);
        r.nonConsume = buffer.readBoolean();
        r.ignoreNbt = buffer.readBoolean();
        return r;
    }

    public RecipeIngredient parse(JsonObject json) {
        Ingredient.Value[] values;
        if (json.has("values")) {
            JsonArray array = json.getAsJsonArray("values");
            values = new Ingredient.Value[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                values[i] = Ingredient.m_43919_((JsonObject)array.get(i).getAsJsonObject());
            }
        } else {
            values = new Ingredient.Value[]{Ingredient.m_43919_((JsonObject)json)};
        }
        RecipeIngredient r = new RecipeIngredient(values);
        if (json.get("ignoreNBT").getAsBoolean()) {
            r.setIgnoreNbt();
        }
        if (json.get("noconsume").getAsBoolean()) {
            r.setNoConsume();
        }
        return r;
    }

    public void write(FriendlyByteBuf buffer, RecipeIngredient ingredient) {
        ItemStack[] items = ingredient.m_43908_();
        buffer.m_130130_(items.length);
        for (ItemStack stack : items) {
            buffer.m_130055_(stack);
        }
        buffer.writeBoolean(ingredient.ignoreConsume());
        buffer.writeBoolean(ingredient.ignoreNbt());
    }
}

