/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jade;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.util.Utils;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;

public class MachineProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation ID = new ResourceLocation("gtlib", "machine");
    public static MachineProvider INSTANCE = new MachineProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            MachineRecipeHandler recipeHandler = machine.recipeHandler.orElse(null);
            if (recipeHandler != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeProgress"))) {
                boolean active;
                long max;
                long cur;
                IElementHelper helper = tooltip.getElementHelper();
                boolean isGenerator = recipeHandler.isGenerator();
                if (accessor.isServerConnected()) {
                    cur = accessor.getServerData().m_128454_("jadeProgress");
                    max = accessor.getServerData().m_128454_("jadeMaxProgress");
                    active = accessor.getServerData().m_128471_("jadeActive");
                } else {
                    cur = isGenerator ? recipeHandler.getPowerGenerated() : (long)recipeHandler.getCurrentProgress();
                    max = isGenerator ? recipeHandler.getTotalPowerToGenerate() : (long)recipeHandler.getMaxProgress();
                    boolean bl = active = machine.getMachineState() == MachineState.ACTIVE;
                }
                if (max > 0L && active) {
                    String maxText;
                    String curText;
                    if (isGenerator) {
                        curText = ChatFormatting.WHITE + String.valueOf(cur) + ChatFormatting.GRAY;
                        maxText = max + (machine.has("eu") ? " EU" : (machine.has("fe") ? " FE" : "")) + " Generated";
                    } else {
                        curText = ChatFormatting.WHITE + String.valueOf(max >= 20L ? Math.round((double)cur / 20.0) : cur) + ChatFormatting.GRAY;
                        maxText = (max >= 20L ? Math.round((double)max / 20.0) : max) + " " + (max >= 20L ? "s" : "t");
                    }
                    MutableComponent text = Utils.translatable("jade.fe", curText, maxText).m_130940_(ChatFormatting.WHITE);
                    IProgressStyle progressStyle = helper.progressStyle().color(-11748585, -11748585);
                    tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
                }
            }
            if (machine instanceof BlockEntityBasicMultiMachine) {
                BlockEntityBasicMultiMachine multiMachine = (BlockEntityBasicMultiMachine)machine;
                if (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeStructureValid")) {
                    boolean validStructure = accessor.isServerConnected() ? accessor.getServerData().m_128471_("jadeStructureValid") : multiMachine.isStructureValid();
                    if (validStructure) {
                        tooltip.add(tooltip.getElementHelper().text((Component)Utils.translatable("gtlib.tooltip.valid_structure", new Object[0]).m_130940_(ChatFormatting.GREEN)));
                    } else {
                        tooltip.add(tooltip.getElementHelper().text((Component)Utils.translatable("gtlib.tooltip.invalid_structure", new Object[0]).m_130940_(ChatFormatting.RED)));
                    }
                }
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            machine.recipeHandler.ifPresent(r -> {
                if (r.isGenerator()) {
                    compoundTag.m_128356_("jadeProgress", r.getPowerGenerated());
                    compoundTag.m_128356_("jadeMaxProgress", r.getTotalPowerToGenerate());
                } else {
                    compoundTag.m_128356_("jadeProgress", (long)r.getCurrentProgress());
                    compoundTag.m_128356_("jadeMaxProgress", (long)r.getMaxProgress());
                }
                compoundTag.m_128379_("jadeActive", machine.getMachineState() == MachineState.ACTIVE);
            });
            if (machine instanceof BlockEntityBasicMultiMachine) {
                BlockEntityBasicMultiMachine multiMachine = (BlockEntityBasicMultiMachine)machine;
                compoundTag.m_128379_("jadeStructureValid", multiMachine.isStructureValid());
            }
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

