/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.util.int2;
import org.gtreimagined.gtlib.util.int4;

public class MachineStateWidget
extends Widget {
    protected final int4 state = new int4(176, 56, 8, 8);
    protected int2 location;
    protected final boolean isRecipe;
    protected final Tier tier;

    protected MachineStateWidget(GuiInstance gui, IGuiElement parent) {
        super(gui, parent);
        this.tier = ((BlockEntityMachine)gui.handler).getMachineTier();
        this.setX(gui.handler.getGui().getMachineData().getMachineStatePos().x);
        this.setY(gui.handler.getGui().getMachineData().getMachineStatePos().y);
        this.setW(gui.handler.getGui().getMachineData().getMachineStateSize().x);
        this.setH(gui.handler.getGui().getMachineData().getMachineStateSize().y);
        this.isRecipe = ((BlockEntityMachine)gui.handler).has("recipe");
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        MachineState machineState = ((BlockEntityMachine)this.gui.handler).getMachineState();
        if (this.isRecipe) {
            if (machineState == MachineState.POWER_LOSS) {
                this.drawTexture(graphics, this.gui.handler.getGui().getMachineData().getMachineStateTexture(this.tier), this.realX(), this.realY(), this.getW(), 0, this.getW(), this.getH(), this.getW() * 2, this.getH());
            } else {
                this.drawTexture(graphics, this.gui.handler.getGui().getMachineData().getMachineStateTexture(this.tier), this.realX(), this.realY(), 0, 0, this.getW(), this.getH(), this.getW() * 2, this.getH());
            }
        }
    }

    @Override
    public void mouseOver(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(graphics, mouseX, mouseY, partialTicks);
        MachineState machineState = ((BlockEntityMachine)this.gui.handler).getMachineState();
        if (this.isRecipe) {
            this.renderTooltip(graphics, (Component)Utils.literal(machineState.getDisplayName()), mouseX, mouseY);
        }
    }

    public static WidgetSupplier build() {
        return MachineStateWidget.builder(MachineStateWidget::new);
    }
}

