/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.event.SlotClickEvent;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class FluidSlotWidget
extends Widget {
    private final int slot;
    private final SlotData<?> slots;
    private FluidStack stack = FluidStack.EMPTY;

    protected FluidSlotWidget(GuiInstance gui, IGuiElement parent, int fluidSlot, SlotData<?> slots) {
        super(gui, parent);
        this.slot = fluidSlot;
        this.slots = slots;
        this.setX(slots.getX());
        this.setY(slots.getY());
        this.setW(16);
        this.setH(16);
    }

    public static WidgetSupplier build(int slot, SlotData<?> slots) {
        return FluidSlotWidget.builder((a, b) -> new FluidSlotWidget((GuiInstance)a, (IGuiElement)b, slot, slots));
    }

    @Override
    public void init() {
        super.init();
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof BlockEntityMachine) {
            BlockEntityMachine blockEntity = (BlockEntityMachine)iGuiHandler;
            this.gui.syncFluidStack(() -> blockEntity.fluidHandler.map(t -> t.getFluidInTank(this.slot)).orElse(FluidStack.EMPTY), stack -> {
                this.stack = stack;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        this.renderFluid(graphics, this.stack, this.realX(), this.realY());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFluid(GuiGraphics graphics, FluidStack fluid, int x, int y) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderHelper.drawFluid(graphics.m_280168_(), Minecraft.m_91087_(), x, y, this.getW(), this.getH(), 16, fluid);
    }

    @Override
    public void mouseOver(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(graphics, mouseX, mouseY, partialTicks);
        if (this.stack.isEmpty()) {
            return;
        }
        int x = this.realX();
        int y = this.realY();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int slotColor = -2130706433;
        this.fillGradient(graphics, x, y, 16, 16, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        ArrayList<Component> str = new ArrayList<Component>();
        str.add(FluidUtils.getFluidDisplayName(this.stack));
        int mb = this.stack.getAmount();
        str.add((Component)Utils.translatable("gtlib.tooltip.fluid.amount", mb + " L").m_130940_(ChatFormatting.BLUE));
        str.add((Component)Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(this.stack.getFluid())).m_130940_(ChatFormatting.RED));
        String liquid = !FluidUtils.isFluidGaseous(this.stack.getFluid()) ? "liquid" : "gas";
        str.add((Component)Utils.translatable("gtlib.tooltip.fluid." + liquid, new Object[0]).m_130940_(ChatFormatting.GREEN));
        GTLibXEIPlugin.addModDescriptor(str, this.stack);
        this.drawHoverText(graphics, str, (int)mouseX, (int)mouseY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        if (!this.isInside(mouseX, mouseY)) {
            return super.keyPressed(keyCode, scanCode, modifiers, mouseX, mouseY);
        }
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (!input.m_84874_().equals("key.keyboard.u") && !input.m_84874_().equals("key.keyboard.r")) {
            return false;
        }
        GTLibXEIPlugin.uses(this.stack, input.m_84874_().equals("key.keyboard.u"));
        return true;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        AbstractGuiEventPacket pkt = this.gui.handler.createGuiPacket(new SlotClickEvent(this.slot, this.slots.getType()));
        this.gui.sendPacket(pkt);
    }
}

