/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.client.gui.screens.Screen;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.ButtonWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.jetbrains.annotations.Nullable;

public class CycleButtonWidget
extends ButtonWidget {
    final ButtonOverlay[] buttons;
    final ToIntFunction<IGuiHandler> syncFunction;
    protected IntFunction<String> tooltipKeyFunction;
    int state = 0;

    public CycleButtonWidget(GuiInstance instance, IGuiElement parent, @Nullable Consumer<ButtonWidget> onPress, ToIntFunction<IGuiHandler> syncFunction, ButtonOverlay ... buttons) {
        super(instance, parent, buttons[0], onPress);
        this.buttons = buttons;
        this.syncFunction = syncFunction;
    }

    @Override
    public void init() {
        this.gui.syncInt(() -> this.syncFunction.applyAsInt(this.gui.handler), i -> {
            this.state = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    @Override
    protected ButtonOverlay getBody() {
        return this.buttons[this.state];
    }

    @Override
    protected String getTooltipKey() {
        if (this.tooltipKeyFunction == null) {
            return super.getTooltipKey();
        }
        return this.tooltipKeyFunction.apply(this.state);
    }

    public CycleButtonWidget setTooltipKeyFunction(IntFunction<String> tooltipKeyFunction) {
        this.tooltipKeyFunction = tooltipKeyFunction;
        return this;
    }

    public static WidgetSupplier build(ToIntFunction<IGuiHandler> syncFunction, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground, ButtonOverlay ... buttons) {
        return CycleButtonWidget.builder((a, b) -> new CycleButtonWidget((GuiInstance)a, (IGuiElement)b, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))), syncFunction, buttons).setRenderBackground(renderBackground));
    }

    public static WidgetSupplier build(ToIntFunction<IGuiHandler> syncFunction, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground, IntFunction<String> tooltipKey, ButtonOverlay ... buttons) {
        return CycleButtonWidget.builder((a, b) -> new CycleButtonWidget((GuiInstance)a, (IGuiElement)b, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))), syncFunction, buttons).setTooltipKeyFunction(tooltipKey).setRenderBackground(renderBackground));
    }
}

