/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.dynamic;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.client.IGTModel;
import org.gtreimagined.gtlib.dynamic.DynamicBakedModel;

public class DynamicModel
implements IGTModel<DynamicModel> {
    protected Int2ObjectOpenHashMap<IGTModel[]> modelConfigs;
    protected String staticMapId;
    protected ResourceLocation particle;

    public DynamicModel(ResourceLocation particle, Int2ObjectOpenHashMap<IGTModel[]> modelConfigs, String staticMapId) {
        this.modelConfigs = modelConfigs;
        this.staticMapId = staticMapId;
        this.particle = particle;
    }

    public DynamicModel(DynamicModel copy) {
        this.modelConfigs = copy.modelConfigs;
        this.staticMapId = copy.staticMapId;
        this.particle = copy.particle;
    }

    @Override
    public BakedModel bakeModel(IGeometryBakingContext configuration, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        return new DynamicBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, this.particle)), this.getBakedConfigs(configuration, bakery, getter, transform, overrides, loc));
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.modelConfigs.forEach((integer, igtModels) -> {
            for (IGTModel model : igtModels) {
                model.resolveParents(modelGetter, context);
            }
        });
    }

    public Int2ObjectOpenHashMap<BakedModel[]> getBakedConfigs(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        Int2ObjectOpenHashMap<BakedModel[]> bakedConfigs = GTLibModelManager.getStaticConfigMap(this.staticMapId);
        this.modelConfigs.forEach((k, v) -> {
            BakedModel[] baked = new BakedModel[((IGTModel[])v).length];
            for (int i = 0; i < baked.length; ++i) {
                baked[i] = v[i].bake(owner, bakery, getter, transform, overrides, loc);
            }
            bakedConfigs.put(k.intValue(), (Object)baked);
        });
        return bakedConfigs;
    }
}

