/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTModelProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GTItemModelProvider
extends GTModelProvider<GTItemModelBuilder>
implements IGTLibProvider {
    protected final String providerName;

    public GTItemModelProvider(String providerDomain, String providerName) {
        super(providerDomain, "item", GTItemModelBuilder::new);
        this.providerName = providerName;
    }

    public String m_6055_() {
        return this.providerName;
    }

    @Override
    public void run() {
        this.registerModels();
    }

    @Override
    public void onCompletion() {
        this.buildAll();
    }

    protected void registerModels() {
        this.processItemModels(this.modid);
    }

    public void processItemModels(String domain) {
        GTAPI.all(Item.class, domain).forEach(i -> GTLibModelManager.onItemModelBuild((ItemLike)i, this));
        GTAPI.all(Block.class, domain).forEach(b -> GTLibModelManager.onItemModelBuild((ItemLike)b, this));
        GTAPI.all(GTFluid.class, domain).forEach(f -> {
            this.modelAndTexture((ItemLike)f.getContainerItem(), "forge", "item/bucket").bucketProperties((Fluid)f.getFluid());
            this.modelAndTexture((ItemLike)f.getFluidBlock(), GTBlockModelBuilder.getSimple()).tex(a -> a.put("all", IClientFluidTypeExtensions.of((FluidType)f.getFluidType()).getFlowingTexture().toString()));
        });
    }

    public GTItemModelBuilder getBuilder(ItemLike item) {
        return (GTItemModelBuilder)this.getBuilder(RegistryUtils.getIdFromItem(item.m_5456_()).m_135815_());
    }

    public GTItemModelBuilder tex(ItemLike item, ResourceLocation ... textures) {
        return this.tex(item, "minecraft:item/generated", textures);
    }

    public GTItemModelBuilder tex(ItemLike item, String parent, ResourceLocation ... textures) {
        GTItemModelBuilder builder = this.getBuilder(item);
        builder.parent(new ResourceLocation(parent));
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    public GTItemModelBuilder blockItem(Block block) {
        return this.blockItem((ItemLike)block.m_5456_());
    }

    public GTItemModelBuilder blockItem(ItemLike item) {
        return (GTItemModelBuilder)this.withParent(RegistryUtils.getIdFromItem(item.m_5456_()).m_135815_(), this.modLoc("block/" + RegistryUtils.getIdFromItem(item.m_5456_()).m_135815_()));
    }

    public ResourceLocation existing(String domain, String path) {
        return new ResourceLocation(domain, path);
    }

    public GTItemModelBuilder getGTBuilder(ItemLike item) {
        return (GTItemModelBuilder)this.getBuilder(RegistryUtils.getIdFromItem(item.m_5456_()).m_135815_());
    }

    public GTItemModelBuilder modelAndTexture(ItemLike item, String namespace, String path) {
        return (GTItemModelBuilder)this.getGTBuilder(item).parent(new ResourceLocation(namespace, path));
    }

    public GTItemModelBuilder modelAndTexture(ItemLike item, String resource) {
        return (GTItemModelBuilder)this.getGTBuilder(item).parent(new ResourceLocation(resource));
    }
}

