/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.event;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.gtreimagined.gtlib.client.SoundHelper;
import org.gtreimagined.gtlib.client.event.ClientEvents;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.tool.IGTTool;

@Mod.EventBusSubscriber(modid="gtlib", value={Dist.CLIENT})
public class ClientEventsForge {
    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        if (ClientEvents.onBlockHighlight(event.getLevelRenderer(), event.getCamera(), event.getTarget(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    protected static void onTooltipAdd(ItemTooltipEvent ev) {
        MaterialType.addTooltip(ev.getItemStack(), ev.getToolTip(), ev.getEntity(), ev.getFlags());
        ClientEvents.onItemTooltip(ev.getItemStack(), ev.getToolTip(), ev.getEntity(), ev.getFlags());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Player player = e.player;
            if (player == null || player.m_21205_().m_41619_()) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof IGTTool)) {
                return;
            }
            IGTTool item = (IGTTool)stack.m_41720_();
            if (item.getGTToolType().getUseAction() != UseAnim.NONE && player.f_20911_) {
                item.getItem().m_5929_(player.m_9236_(), (LivingEntity)player, stack, stack.m_41613_());
            }
        }
    }

    @SubscribeEvent
    public static void onGuiMouseScrollPre(ScreenEvent.MouseScrolled e) {
        ClientEvents.onGuiMouseScrollPre(e.getScrollDelta());
    }

    @SubscribeEvent
    public static void onGuiMouseClickPre(ScreenEvent.MouseButtonPressed e) {
        ClientEvents.onGuiMouseClickPre(e.getButton());
    }

    @SubscribeEvent
    public static void onGuiMouseReleasedPre(ScreenEvent.MouseButtonReleased e) {
        ClientEvents.onGuiMouseReleasedPre(e.getButton());
    }

    @SubscribeEvent
    public static void worldUnload(LevelEvent.Unload ev) {
        SoundHelper.worldUnload(ev.getLevel());
    }
}

