/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.dynamic;

import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.SimpleModelState;
import org.gtreimagined.gtlib.client.dynamic.DynamicTextureProvider;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.mixin.client.BlockModelAccessor;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class DynamicTexturers {
    public static final DynamicTextureProvider<ICover, ICover.DynamicKey> COVER_DYNAMIC_TEXTURER = new DynamicTextureProvider(t -> {
        if (t.currentDir == ((ICover)t.source).side()) {
            BlockModel m;
            try {
                m = ModelUtils.getModelBakery().m_119364_(((ICover)t.source).getModel(t.type, Direction.SOUTH));
            }
            catch (Exception e) {
                GTLib.LOGGER.error((Object)e);
                return Collections.emptyList();
            }
            BlockModel model = m;
            ((BlockModelAccessor)model).getTextureMap().put("base", (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(((ICover.DynamicKey)t.key).machineTexture)));
            ((ICover)t.source).setTextures((name, texture) -> ((BlockModelAccessor)model).getTextureMap().put((String)name, (Either<Material, String>)Either.left((Object)ModelUtils.getBlockMaterial(texture))));
            Transformation base = RenderHelper.faceRotation(((ICover)t.source).side());
            ObjectArrayList ret = new ObjectArrayList();
            ret.addAll(DynamicTexturers.bakeVanilla(model, ModelUtils.getDefaultTextureGetter(), new SimpleModelState(base), ((ICover)t.source).getModel(t.type, Direction.SOUTH), true));
            return ((ICover)t.source).transformQuads(t.state, (List<BakedQuad>)ret);
        }
        return Collections.emptyList();
    });

    @Nullable
    private static Predicate<Map.Entry<String, BakedModel>> getEntryPredicate(DynamicTextureProvider.BuilderData t) {
        ICoverHandler iCoverHandler;
        BlockEntity blockEntity = t.getBlockEntity();
        if (blockEntity instanceof ICoverHandlerProvider) {
            ICoverHandlerProvider provider = (ICoverHandlerProvider)blockEntity;
            iCoverHandler = provider.getCoverHandler().orElse(null);
        } else {
            iCoverHandler = null;
        }
        ICoverHandler coverHandler = iCoverHandler;
        Predicate<Map.Entry> predicate = null;
        if (coverHandler != null) {
            predicate = e -> {
                String key = (String)e.getKey();
                if (key.isEmpty()) {
                    return true;
                }
                Direction dir = Utils.rotate(t.currentDir, Direction.m_122402_((String)key));
                if (dir == null) {
                    throw new NullPointerException("Dir null in getBlockQuads");
                }
                boolean ok = coverHandler.get(dir).isEmpty();
                return ok;
            };
        }
        return predicate;
    }

    private static List<BakedQuad> bakeVanilla(BlockModel model, Function<Material, TextureAtlasSprite> textureGetter, ModelState modelState, ResourceLocation modelLocation, boolean guiLight3d) {
        TextureAtlasSprite textureatlassprite = textureGetter.apply(model.m_111480_("particle"));
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (BlockElement blockelement : model.m_111436_()) {
            for (Direction direction : blockelement.f_111310_.keySet()) {
                BlockElementFace blockelementface = (BlockElementFace)blockelement.f_111310_.get(direction);
                TextureAtlasSprite textureatlassprite1 = textureGetter.apply(model.m_111480_(blockelementface.f_111356_));
                bakedQuads.add(BlockModelAccessor.invokeBakeFace(blockelement, blockelementface, textureatlassprite1, direction, modelState, modelLocation));
            }
        }
        return bakedQuads;
    }
}

