/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.feature;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.worldgen.GTLibConfiguredFeatures;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.gtreimagined.gtlib.worldgen.feature.GTFeature;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOre;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOreData;

public class FeatureSmallOres
extends GTFeature<NoneFeatureConfiguration> {
    public FeatureSmallOres() {
        super(NoneFeatureConfiguration.f_67815_, SmallOre.class);
    }

    @Override
    public String getId() {
        return "small_ores";
    }

    @Override
    public boolean enabled() {
        return GTLibConfig.SMALL_ORES.get() && !SmallOreData.INSTANCE.getVeins().isEmpty();
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettingsBuilder gen, MobSpawnSettings.Builder spawns, Registry<PlacedFeature> placedFeatureRegistry) {
        gen.m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.getPlacedFeatureFromKey(placedFeatureRegistry, GTLibConfiguredFeatures.SMALL_ORES));
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> placer) {
        RandomSource random = placer.m_225041_();
        BlockPos blockpos = placer.m_159777_();
        WorldGenLevel world = placer.m_159774_();
        int chunkX = placer.m_159777_().m_123341_() >> 4;
        int chunkZ = placer.m_159777_().m_123343_() >> 4;
        int chunkCornerX = chunkX * 16;
        int chunkCornerZ = chunkZ * 16;
        int worldMinY = world.m_6042_().f_156647_();
        int worldMaxY = world.m_6042_().f_156647_() + world.m_6042_().f_156648_();
        Collection smallOres = SmallOreData.INSTANCE.getVeins((Level)world.m_6018_()).values();
        int spawned = 0;
        for (SmallOre smallOre : smallOres) {
            if (!smallOre.material().has(GTMaterialTypes.SMALL_ORE)) continue;
            int minY = Math.max(worldMinY, smallOre.minY());
            int maxY = Math.min(worldMaxY, smallOre.maxY());
            int j = Math.max(1, smallOre.amountPerChunk() / 2 + random.m_188503_(smallOre.amountPerChunk()) / 2);
            for (int i = 0; i < j; ++i) {
                boolean spawn;
                BlockPos pos = new BlockPos(chunkCornerX + random.m_188503_(16), minY + random.m_188503_(Math.max(1, maxY - minY)), chunkCornerZ + random.m_188503_(16));
                if (!smallOre.isBiomeValid((Holder<Biome>)world.m_204166_(pos)) || !(spawn = WorldGenHelper.setOre((LevelAccessor)world, pos, smallOre.material(), GTMaterialTypes.SMALL_ORE))) continue;
                ++spawned;
            }
        }
        return spawned > 0;
    }
}

