/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryUtils {
    private static ImmutableMap<Item, Integer> FUEL_LIST = null;

    public static Map<Item, Integer> getAllBurnables() {
        if (FUEL_LIST == null) {
            ForgeHooks.updateBurns();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ForgeRegistries.ITEMS.getValues().forEach(i -> {
                int burnTime = ForgeHooks.getBurnTime((ItemStack)i.m_7968_(), null);
                if (burnTime > 0) {
                    builder.put(i, (Object)burnTime);
                }
            });
            FUEL_LIST = builder.build();
        }
        return FUEL_LIST;
    }

    public static boolean blockExists(ResourceLocation id) {
        return ForgeRegistries.BLOCKS.containsKey(id);
    }

    public static boolean itemExists(ResourceLocation id) {
        return ForgeRegistries.ITEMS.containsKey(id);
    }

    public static boolean fluidExists(ResourceLocation id) {
        return ForgeRegistries.FLUIDS.containsKey(id);
    }

    public static Block getBlockFromId(ResourceLocation id) {
        return (Block)ForgeRegistries.BLOCKS.getValue(id);
    }

    public static Item getItemFromID(ResourceLocation id) {
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public static Fluid getFluidFromID(ResourceLocation id) {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(id);
    }

    public static ResourceLocation getIdFromBlock(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getIdFromItem(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getIdFromFluid(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static Block getBlockFromId(String domain, String id) {
        return RegistryUtils.getBlockFromId(new ResourceLocation(domain, id));
    }

    public static Item getItemFromID(String domain, String id) {
        return RegistryUtils.getItemFromID(new ResourceLocation(domain, id));
    }
}

