/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.condition;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("gtlib", "config");
    private final String configName;

    ConfigCondition(String config) {
        this.configName = config;
    }

    public ConfigCondition(Class clazz, String variableName) {
        this(clazz.getCanonicalName() + "." + variableName);
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        try {
            int lastIndex = this.configName.lastIndexOf(46);
            return Class.forName(this.configName.substring(0, lastIndex)).getField(this.configName.substring(lastIndex + 1)).getBoolean(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NullPointerException e) {
            return true;
        }
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("config", value.configName);
        }

        public ConfigCondition read(JsonObject json) {
            return new ConfigCondition(GsonHelper.m_13906_((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

