/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.ItemPipe;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockItemPipe<T extends ItemPipe<T>>
extends BlockPipe<T> {
    final boolean restricted;

    public BlockItemPipe(T type, PipeSize size, boolean restricted) {
        super((restricted ? "restrictive_" : "") + ((PipeType)type).getId(), type, size, 0);
        this.restricted = restricted;
        if (restricted) {
            this.side = new Texture("gtlib", "block/pipe/pipe_restrictor_side");
        }
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos, boolean simple) {
        if (world.f_46443_ || simple) {
            return info;
        }
        info.add("Capacity: " + ((ItemPipe)this.getType()).getCapacity(this.getSize()));
        return info;
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter p_49817_, List<Component> tooltip, TooltipFlag p_49819_) {
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.stepsize", ((ItemPipe)this.type).getStepsize(this.getSize()) * (this.restricted ? 100 : 1)).m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.bandwidth", Utils.literal(((ItemPipe)this.type).getCapacity(this.getSize()) + "/s").m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Utils.literal("----------"));
            tooltip.add((Component)Utils.translatable("gtlib.pipe.item.info", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)Utils.literal("----------"));
        } else if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("covers")) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.more", new Object[0]));
        }
        super.m_5871_(stack, p_49817_, tooltip, p_49819_);
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Player player;
        EntityCollisionContext cont;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (cont = (EntityCollisionContext)context).m_193113_()) instanceof Player && Utils.getToolType(player = (Player)entity) == GTTools.WRENCH_ALT) {
            return Shapes.m_83144_();
        }
        return super.m_5940_(state, world, pos, context);
    }
}

