/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.FluidPipe;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockFluidPipe<T extends FluidPipe<T>>
extends BlockPipe<T> {
    public BlockFluidPipe(T type, PipeSize size) {
        super(((PipeType)type).getId(), type, size, 0);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.bandwidth", ((FluidPipe)this.getType()).getPressure(this.getSize()) + " L/t").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.capacity", ((FluidPipe)this.getType()).getPressure(this.getSize()) * 2 + "L").m_130940_(ChatFormatting.AQUA));
        if (((FluidPipe)this.getType()).isGasProof()) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.gas_proof", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        if (((FluidPipe)this.getType()).isAcidProof()) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.acid_proof", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.max_temperature", new Object[0]).m_130946_(": " + ((FluidPipe)this.getType()).getMaxTemperature()).m_130940_(ChatFormatting.DARK_RED));
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (worldIn.f_46443_ || ((FluidPipe)this.type).isHeatProof()) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof BlockEntityFluidPipe) {
                BlockEntityFluidPipe fluidPipe = (BlockEntityFluidPipe)blockEntity;
                long temp = fluidPipe.getCurrentTemperature();
                if (Utils.isFullHazmatSuit(entity)) {
                    return;
                }
                BlockFluidPipe.applyTemperatureDamage((Entity)entity, temp, 1.0f, 1.0f);
            }
        }
    }

    public static boolean applyTemperatureDamage(Entity entity, long temperature, float multiplier, float cap) {
        if (temperature > 320L) {
            entity.m_6469_(entity.m_9236_().m_269111_().m_269047_(), Math.max(1.0f, Math.min(cap, multiplier * (float)(temperature - 300L) / 50.0f)));
            return true;
        }
        if (temperature < 260L) {
            entity.m_6469_(entity.m_9236_().m_269111_().m_269109_(), Math.max(1.0f, Math.min(cap, multiplier * (float)(270L - temperature) / 25.0f)));
            return true;
        }
        return false;
    }
}

