/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.xei.renderer;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.gtreimagined.gtlib.integration.xei.renderer.IRecipeInfoRenderer;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.IRecipe;

public class InfoRenderers {
    public static final IRecipeInfoRenderer BLASTING_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String additional = recipe.getDuration() < 1200 ? "" : (recipe.getDuration() < 36000 ? " (" + (float)recipe.getDuration() / 20.0f + " secs)" : " (" + (float)recipe.getDuration() / 1200.0f + " mins)");
            String power = "Duration: " + recipe.getDuration() + " ticks" + additional;
            String euT = "EU/t: " + recipe.getPower();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " EU";
            String temperature = "Temperature: " + recipe.getSpecialValue() + " K";
            Tier tier = Tier.getTier(recipe.getPower() / (long)recipe.getAmps());
            String formattedText = " (" + tier.getId().toUpperCase() + ")";
            this.renderString(graphics, power, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, euT, font, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, formattedText, font, 5 + this.stringWidth(euT, font), 10.0f, Tier.EV.getRarityFormatting().m_126665_(), guiOffsetX, guiOffsetY);
            this.renderString(graphics, temperature, font, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, total, font, 5.0f, 30.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 4;
        }
    };
    public static final IRecipeInfoRenderer BASIC_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            String additional = recipe.getDuration() < 1200 ? "" : (recipe.getDuration() < 36000 ? " (" + (float)recipe.getDuration() / 20.0f + " secs)" : " (" + (float)recipe.getDuration() / 1200.0f + " mins)");
            String duration = "Duration: " + recipe.getDuration() + " ticks" + additional;
            this.renderString(graphics, duration, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 1;
        }
    };
    public static final IRecipeInfoRenderer EMPTY_RENDERER = (stack, recipe, fontRenderer, guiOffsetX, guiOffsetY) -> {};
    public static final IRecipeInfoRenderer DEFAULT_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String additional = recipe.getDuration() < 1200 ? "" : (recipe.getDuration() < 36000 ? " (" + (float)recipe.getDuration() / 20.0f + " secs)" : " (" + (float)recipe.getDuration() / 1200.0f + " mins)");
            String power = "Duration: " + recipe.getDuration() + " ticks" + additional;
            String euT = "EU/t: " + recipe.getPower();
            String amps = "Amps: " + recipe.getAmps();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " EU";
            Tier tier = Tier.getTier(recipe.getPower() / (long)recipe.getAmps());
            String formattedText = " (" + tier.getId().toUpperCase() + ")";
            this.renderString(graphics, power, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, euT, font, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, formattedText, font, 5 + this.stringWidth(euT, font), 10.0f, Tier.EV.getRarityFormatting().m_126665_(), guiOffsetX, guiOffsetY);
            this.renderString(graphics, amps, font, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, total, font, 5.0f, 30.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 4;
        }
    };
    public static final IRecipeInfoRenderer FE_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            if (recipe.getDuration() == 0 && recipe.getPower() == 0L) {
                return;
            }
            String additional = recipe.getDuration() < 1200 ? "" : (recipe.getDuration() < 36000 ? " (" + (float)recipe.getDuration() / 20.0f + " secs)" : " (" + (float)recipe.getDuration() / 1200.0f + " mins)");
            String power = "Duration: " + recipe.getDuration() + " ticks" + additional;
            String euT = "FE/t: " + recipe.getPower();
            String total = "Total: " + recipe.getPower() * (long)recipe.getDuration() + " FE";
            this.renderString(graphics, power, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, euT, font, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, total, font, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 3;
        }
    };
    public static final IRecipeInfoRenderer FUEL_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            String fuelPerMb = "EU/L: " + (double)recipe.getPower() / (double)Objects.requireNonNull(recipe.getInputFluids()).get(0).getAmount();
            String fuelPerB = "Fluid Amount / tick: " + Objects.requireNonNull(recipe.getInputFluids()).get(0).getAmount();
            this.renderString(graphics, fuelPerMb, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, fuelPerB, font, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 2;
        }
    };
    public static final IRecipeInfoRenderer STEAM_RENDERER = new IRecipeInfoRenderer(){

        @Override
        public void render(GuiGraphics graphics, IRecipe recipe, Font font, int guiOffsetX, int guiOffsetY) {
            String additional = recipe.getDuration() < 1200 ? "" : (recipe.getDuration() < 36000 ? " (" + (float)recipe.getDuration() / 20.0f + " secs)" : " (" + (float)recipe.getDuration() / 1200.0f + " mins)");
            String power = "Duration: " + recipe.getDuration() + " ticks" + additional;
            String euT = "Steam: ";
            String total = "Total steam: " + (long)recipe.getDuration() * recipe.getPower() + " mb";
            this.renderString(graphics, power, font, 5.0f, 0.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, euT + recipe.getPower() + "mb/t", font, 5.0f, 10.0f, guiOffsetX, guiOffsetY);
            this.renderString(graphics, total, font, 5.0f, 20.0f, guiOffsetX, guiOffsetY);
        }

        @Override
        public int getRows() {
            return 3;
        }
    };
}

