/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.kubejs;

import dev.latvian.mods.kubejs.event.EventJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayer;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerBuilder;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerOre;
import org.gtreimagined.gtlib.worldgen.vein.Vein;
import org.gtreimagined.gtlib.worldgen.vein.VeinBuilder;

public class GTWorldEvent
extends EventJS {
    public final List<Vein> VEINS = new ObjectArrayList();
    public final List<StoneLayer> STONE_LAYERS = new ObjectArrayList();
    public final Int2ObjectOpenHashMap<List<StoneLayerOre>> COLLISION_MAP = new Int2ObjectOpenHashMap();
    public boolean disableBuiltin = false;

    public final void vein(String id, int minY, int maxY, int weight, int density, int size, Material primary, Material secondary, Material between, Material sporadic, String ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            dimensions = new String[]{"overworld"};
        }
        this.VEINS.add(new VeinBuilder(new ResourceLocation("kubejs", id)).asOreVein(minY, maxY, weight, density, size, primary, secondary, between, sporadic, (ResourceKey[])Arrays.stream(dimensions).map(t -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(t))).toArray(ResourceKey[]::new)).buildVein());
    }

    public final void stoneLayer(String id, String stoneType, int weight, String ... dimensionKeys) {
        if (dimensionKeys == null || dimensionKeys.length == 0) {
            dimensionKeys = new String[]{"overworld"};
        }
        List<ResourceKey<Level>> dimension = Arrays.stream(dimensionKeys).map(dimensionKey -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionKey))).toList();
        StoneType type = Objects.requireNonNull(GTAPI.get(StoneType.class, stoneType));
        this.STONE_LAYERS.add(new StoneLayerBuilder(new ResourceLocation("kubejs", id)).withStone(type).withWeight(weight).inDimensions(dimension).buildVein());
    }

    public final void disableBuiltin() {
        this.disableBuiltin = true;
    }

    public void addCollision(BlockState top, BlockState bottom, StoneLayerOre ... oresToAdd) {
        ((List)this.COLLISION_MAP.computeIfAbsent(Objects.hash(top, bottom), k -> new ObjectArrayList())).addAll(Arrays.asList(oresToAdd));
    }
}

