/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.integration.jei.GTLibJEIPlugin;
import org.gtreimagined.gtlib.integration.jei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOre;

public class SmallOreCategory
implements IRecipeCategory<SmallOre> {
    IDrawable icon = GTLibJEIPlugin.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_41834_.m_7968_());
    IDrawable background = GTLibJEIPlugin.guiHelper.drawableBuilder(new ResourceLocation("gtlib", "textures/gui/background/machine_basic.png"), 3, 3, 170, 60).addPadding(0, 60, 0, 0).build();
    public static final RecipeType<SmallOre> SMALL_ORES = new RecipeType(new ResourceLocation("gtlib", "small_ores"), SmallOre.class);

    public Component getTitle() {
        return Utils.translatable("jei.category.gtlib.small_ores", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<SmallOre> getRecipeType() {
        return SMALL_ORES;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmallOre recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, GTAPI.all(StoneType.class).stream().filter(s -> s.doesGenerateOre() && s != VanillaStoneTypes.BEDROCK).map(s -> ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.SMALL_ORE.get()).get(recipe.material(), (StoneType)s).asBlock()).map(ItemStack::new).toList());
        ArrayList<List<Object>> drops = new ArrayList<List<Object>>();
        ArrayList stoneDusts = new ArrayList();
        GTAPI.all(StoneType.class).stream().filter(s -> s.doesGenerateOre() && s != VanillaStoneTypes.BEDROCK).forEach(s -> {
            if (s.getMaterial().has(GTMaterialTypes.DUST)) {
                stoneDusts.add(GTMaterialTypes.DUST.get(s.getMaterial(), 1));
            }
        });
        if (!stoneDusts.isEmpty()) {
            drops.add(stoneDusts);
        }
        if (recipe.material().has(GTMaterialTypes.EXQUISITE_GEM)) {
            drops.add(List.of(GTMaterialTypes.EXQUISITE_GEM.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.FLAWLESS_GEM)) {
            drops.add(List.of(GTMaterialTypes.FLAWLESS_GEM.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.GEM)) {
            drops.add(List.of(GTMaterialTypes.GEM.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.FLAWED_GEM)) {
            drops.add(List.of(GTMaterialTypes.FLAWED_GEM.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.CHIPPED_GEM)) {
            drops.add(List.of(GTMaterialTypes.CHIPPED_GEM.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.CRUSHED_ORE)) {
            drops.add(List.of(GTMaterialTypes.CRUSHED_ORE.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.IMPURE_DUST)) {
            drops.add(List.of(GTMaterialTypes.IMPURE_DUST.get(recipe.material(), 1)));
        }
        if (recipe.material().has(GTMaterialTypes.DUST) && !recipe.material().has(GTMaterialTypes.CRUSHED_ORE) && !recipe.material().has(GTMaterialTypes.IMPURE_DUST) && !recipe.material().has(GTMaterialTypes.GEM)) {
            drops.add(List.of(GTMaterialTypes.DUST.get(recipe.material(), 1)));
        }
        for (int i = 0; i < 8 && i < drops.size(); ++i) {
            int x = i % 4;
            int y = i / 4;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 42 + x * 18, 55 + y * 18).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)drops.get(i));
        }
        GTLibJEIPlugin.addDimensionSlots(builder, recipe.dimensions());
    }

    public void draw(SmallOre recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int x = RecipeMapCategory.JEI_OFFSET_X;
        int y = RecipeMapCategory.JEI_OFFSET_Y + 3;
        String fullId = recipe.getLoc().m_135815_();
        this.renderString(graphics, "Vein Name: " + Utils.lowerUnderscoreToUpperSpaced(fullId), Minecraft.m_91087_().f_91062_, 0.0f, 18.0f, 0, x, y);
        this.renderString(graphics, "MinY: " + (Serializable)(recipe.minY() == Integer.MIN_VALUE ? "N/A" : Integer.valueOf(recipe.minY())) + " MaxY: " + (Serializable)(recipe.maxY() == Integer.MAX_VALUE ? "N/A" : Integer.valueOf(recipe.maxY())), Minecraft.m_91087_().f_91062_, 0.0f, 28.0f, 0, x, y);
        this.renderString(graphics, "Amount per chunk: " + recipe.amountPerChunk(), Minecraft.m_91087_().f_91062_, 0.0f, 38.0f, 0, x, y);
        this.renderString(graphics, "Drops: ", Minecraft.m_91087_().f_91062_, 0.0f, 58.0f, 0, x, y);
        this.renderString(graphics, "Generated world:", Minecraft.m_91087_().f_91062_, 0.0f, 88.0f, 0, x, y);
    }

    void renderString(GuiGraphics graphics, String string, Font font, float x, float y, int color, int guiOffsetX, int guiOffsetY) {
        graphics.drawString(font, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color, false);
    }
}

