/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.util.int2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureWidget
extends Widget {
    final ResourceLocation texture;
    int textureX = 256;
    int textureY = 256;

    protected TextureWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent, ResourceLocation texture, int2 pos, int2 size) {
        super(gui, parent);
        this.texture = texture;
        this.setX(pos.x);
        this.setY(pos.y);
        this.setW(size.x);
        this.setH(size.y);
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        this.drawTexture(graphics, this.texture, this.realX(), this.realY(), 0, 0, this.getW(), this.getH(), this.textureX, this.textureY);
    }

    public static WidgetSupplier build(ResourceLocation texture, int2 pos, int2 size) {
        return TextureWidget.builder((a, b) -> new TextureWidget((GuiInstance)a, (IGuiElement)b, texture, pos, size));
    }

    public static WidgetSupplier build(ResourceLocation texture, int2 pos, int2 size, int textureX, int textureY) {
        return TextureWidget.builder((a, b) -> new TextureWidget((GuiInstance)a, (IGuiElement)b, texture, pos, size).setTextureX(textureX).setTextureY(textureY));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Generated
    public TextureWidget setTextureX(int textureX) {
        this.textureX = textureX;
        return this;
    }

    @Generated
    public TextureWidget setTextureY(int textureY) {
        this.textureY = textureY;
        return this;
    }
}

