/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.fluid;

import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.fluid.GTClientFluidTypeExtension;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;

public class GTMaterialFluid
extends GTFluid {
    protected Material material;
    protected MaterialType<?> type;

    public GTMaterialFluid(String domain, Material material, MaterialType<?> type, FluidType.Properties builder, BlockBehaviour.Properties blockProperties, IClientFluidTypeExtensions extensions) {
        super(domain, type.getId() + "_" + material.getId(), GTMaterialFluid.modifyProperties(material, builder), blockProperties, extensions);
        this.material = material;
        this.type = type;
    }

    public GTMaterialFluid(String domain, Material material, MaterialType<?> type) {
        this(domain, material, type, GTMaterialFluid.prepareFluidTypeProperties(material, type), GTMaterialFluid.prepareProperties(material), GTMaterialFluid.prepareExtensions(material, type));
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    private static FluidType.Properties modifyProperties(Material material, FluidType.Properties properties) {
        if (material.has(MaterialTags.FLUID_TYPE_PROPERTIES)) {
            MaterialTags.FLUID_TYPE_PROPERTIES.get(material).accept(properties);
        }
        return properties;
    }

    private static FluidType.Properties prepareFluidTypeProperties(Material material, MaterialType<?> type) {
        int density;
        int n = material.has(MaterialTags.FLUID_DENSITY) ? MaterialTags.FLUID_DENSITY.getInt(material) : (type == GTMaterialTypes.GAS ? 1 : (density = material.has(MaterialTags.MOLTEN) ? 3000 : 1000));
        if (type == GTMaterialTypes.GAS) {
            return GTMaterialFluid.getDefaultFluidTypeProperties(false).viscosity(200).density(density).temperature(MaterialTags.GAS_TEMPERATURE.getInt(material));
        }
        FluidType.Properties properties = GTMaterialFluid.getDefaultFluidTypeProperties(material.has(MaterialTags.MOLTEN)).density(density);
        if (material.has(MaterialTags.MOLTEN)) {
            properties.viscosity(6000).lightLevel(15);
        }
        return properties.temperature(MaterialTags.LIQUID_TEMPERATURE.getInt(material));
    }

    private static IClientFluidTypeExtensions prepareExtensions(Material material, MaterialType<?> type) {
        if (type == GTMaterialTypes.GAS) {
            return GTClientFluidTypeExtension.builder().stillTexture(GAS_TEXTURE).flowingTexture(GAS_FLOW_TEXTURE).overlayTexture(OVERLAY_TEXTURE).tintColor(0x46000000 | material.getRGB() & 0xFFFFFF).build();
        }
        GTClientFluidTypeExtension.GTClientFluidTypeExtensionBuilder b = GTClientFluidTypeExtension.builder();
        b.overlayTexture(OVERLAY_TEXTURE);
        if (material.has(MaterialTags.MOLTEN)) {
            b.stillTexture(LIQUID_HOT_STILL_TEXTURE).flowingTexture(LIQUID_HOT_FLOW_TEXTURE).build();
        } else {
            b.stillTexture(LIQUID_STILL_TEXTURE).flowingTexture(LIQUID_FLOW_TEXTURE).build();
        }
        int alpha = material.has(MaterialTags.MOLTEN) ? -16777216 : -1694498816;
        b.tintColor(alpha | material.getRGB() & 0xFFFFFF);
        return b.build();
    }

    private static BlockBehaviour.Properties prepareProperties(Material material) {
        return GTMaterialFluid.getDefaultBlockProperties().m_60953_(s -> material.has(MaterialTags.MOLTEN) ? 15 : 0);
    }

    @Override
    public String getLang(String lang) {
        if (lang.equals("en_us")) {
            String display = this.material.getDisplayNameString();
            if (this.isGasType()) {
                return display;
            }
            String liquid = this.material.has(MaterialTags.MOLTEN) ? "Molten " : "";
            return liquid + display;
        }
        return super.getLang(lang);
    }

    private boolean isGasType() {
        return this.type == GTMaterialTypes.GAS || this.getFluid().m_205067_(Tags.Fluids.GASEOUS);
    }
}

