/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.tuple.Pair;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialStack;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.material.data.ArmorData;
import org.gtreimagined.gtlib.material.data.HandleData;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.tool.GTToolType;

public class MaterialEvent<T extends MaterialEvent<T>> {
    protected Material material = Material.NULL;

    public T setMaterial(Material material) {
        this.material = material;
        return (T)this;
    }

    public T setMaterial(String material) {
        return this.setMaterial(Material.get(material));
    }

    public T asDust(IMaterialTag ... tags) {
        this.flags(GTMaterialTypes.DUST, GTMaterialTypes.SMALL_DUST, GTMaterialTypes.TINY_DUST);
        this.flags(tags);
        return (T)this;
    }

    public T asDust(int meltingPoint, IMaterialTag ... tags) {
        MaterialTags.MELTING_POINT.add(this.material, meltingPoint);
        if (meltingPoint > 295) {
            // empty if block
        }
        return this.asDust(tags);
    }

    public T asSolid(IMaterialTag ... tags) {
        this.asDust(tags);
        ((MaterialEvent)this.flags(GTMaterialTypes.INGOT, GTMaterialTypes.NUGGET, GTMaterialTypes.CHUNK, GTMaterialTypes.BLOCK)).asFluid();
        return (T)this;
    }

    public T asSolid(int meltingPoint, IMaterialTag ... tags) {
        MaterialTags.MELTING_POINT.add(this.material, meltingPoint);
        return this.asSolid(tags);
    }

    public T asMetal(IMaterialTag ... tags) {
        this.flags(MaterialTags.METAL, MaterialTags.MOLTEN);
        return this.asSolid(tags);
    }

    public T asMetal(int meltingPoint, IMaterialTag ... tags) {
        this.flags(MaterialTags.METAL, MaterialTags.MOLTEN);
        return this.asSolid(meltingPoint, tags);
    }

    public T asOre(int minXp, int maxXp, boolean small, IMaterialTag ... tags) {
        MaterialTags.EXP_RANGE.add(this.material, UniformInt.m_146622_((int)minXp, (int)maxXp));
        return this.asOre(small, tags);
    }

    public T asOre(IMaterialTag ... tags) {
        return this.asOre(true, tags);
    }

    public T asOre(boolean small, IMaterialTag ... tags) {
        this.asDust(GTMaterialTypes.ORE, GTMaterialTypes.BEARING_ROCK, GTMaterialTypes.CRUSHED_ORE, GTMaterialTypes.PURIFIED_ORE, GTMaterialTypes.REFINED_ORE, GTMaterialTypes.IMPURE_DUST, GTMaterialTypes.PURE_DUST, GTMaterialTypes.RAW_ORE, GTMaterialTypes.RAW_ORE_BLOCK);
        if (small) {
            this.flags(GTMaterialTypes.SMALL_ORE);
        }
        if (!this.has(MaterialTags.EXP_RANGE)) {
            MaterialTags.EXP_RANGE.add(this.material, UniformInt.m_146622_((int)1, (int)5));
        }
        this.flags(tags);
        return (T)this;
    }

    public T asOreStone(int minXp, int maxXp, IMaterialTag ... tags) {
        this.asOre(minXp, maxXp, false, tags);
        this.flags(GTMaterialTypes.ORE_STONE);
        return (T)this;
    }

    public T asOreStone(IMaterialTag ... tags) {
        this.asOre(tags);
        this.asDust(GTMaterialTypes.ORE_STONE, GTMaterialTypes.ORE, GTMaterialTypes.BEARING_ROCK, GTMaterialTypes.CRUSHED_ORE, GTMaterialTypes.PURIFIED_ORE, GTMaterialTypes.REFINED_ORE, GTMaterialTypes.IMPURE_DUST, GTMaterialTypes.PURE_DUST);
        this.flags(tags);
        return (T)this;
    }

    public T asGemBasic(boolean transparent, IMaterialTag ... tags) {
        this.asDust(tags);
        this.flags(GTMaterialTypes.GEM, GTMaterialTypes.BLOCK);
        if (transparent) {
            this.flags(MaterialTags.TRANSPARENT, GTMaterialTypes.PLATE, GTMaterialTypes.LENS);
        }
        return (T)this;
    }

    public T asGem(boolean transparent, IMaterialTag ... tags) {
        this.asGemBasic(transparent, tags);
        this.flags(GTMaterialTypes.EXQUISITE_GEM);
        return (T)this;
    }

    public T asFluid() {
        this.flags(GTMaterialTypes.LIQUID);
        return (T)this;
    }

    public T asFluid(int fuelPower) {
        MaterialTags.FUEL_POWER.add(this.material, fuelPower);
        return this.asFluid();
    }

    public T asFluid(int fuelPower, int temp) {
        MaterialTags.LIQUID_TEMPERATURE.add(this.material, temp);
        if (temp >= 400 && this.material.has(MaterialTags.METAL)) {
            this.flags(MaterialTags.MOLTEN);
        }
        return this.asFluid(fuelPower);
    }

    public T asGas() {
        this.flags(GTMaterialTypes.GAS);
        return (T)this;
    }

    public T asGas(int fuelPower) {
        MaterialTags.FUEL_POWER.add(this.material, fuelPower);
        return this.asGas();
    }

    public T asGas(int fuelPower, int temp) {
        MaterialTags.GAS_TEMPERATURE.add(this.material, temp);
        return this.asGas(fuelPower);
    }

    public T fluidDensity(int density) {
        MaterialTags.FLUID_DENSITY.add(this.material, density);
        return (T)this;
    }

    public T harvestLevel(int harvestLevel) {
        MaterialTags.MINING_LEVEL.add(this.material, harvestLevel);
        return (T)this;
    }

    public T setAllowedTypes(GTToolType ... toolTypes) {
        if (!this.has(MaterialTags.TOOLS)) {
            return (T)this;
        }
        ToolData data = MaterialTags.TOOLS.get(this.material);
        List<GTToolType> toolTypesList = toolTypes.length > 0 ? Arrays.asList(toolTypes) : GTAPI.all(GTToolType.class);
        MaterialTags.TOOLS.add(this.material, new ToolData(data.toolDamage(), data.toolSpeed(), data.toolDurability(), data.toolQuality(), data.handleMaterial(), data.toolEnchantment(), toolTypesList));
        return (T)this;
    }

    public T addArmor(int[] armor, float toughness, float knockbackResistance, int armorDurabilityFactor) {
        return this.addArmor(armor, toughness, knockbackResistance, armorDurabilityFactor, (ImmutableMap<Enchantment, Integer>)ImmutableMap.of());
    }

    public T addArmor(int[] armor, float toughness, float knockbackResistance, int armorDurabilityFactor, ImmutableMap<Enchantment, Integer> toolEnchantment) {
        if (armor.length != 4) {
            GTLib.LOGGER.info("Material " + this.material.getId() + " unable to add armor, protection array must have exactly 4 values");
            return (T)this;
        }
        if (this.has(GTMaterialTypes.INGOT)) {
            this.flags(GTMaterialTypes.PLATE);
        }
        MaterialTags.ARMOR.add(this.material, new ArmorData(armor, toughness, knockbackResistance, armorDurabilityFactor, toolEnchantment));
        return (T)this;
    }

    public T addArmor(Material material, ImmutableMap<Enchantment, Integer> toolEnchantment) {
        if (!material.has(MaterialTags.ARMOR)) {
            return (T)this;
        }
        ArmorData data = MaterialTags.ARMOR.get(material);
        return this.addArmor(data.armor(), data.toughness(), data.knockbackResistance(), data.armorDurabilityFactor(), toolEnchantment);
    }

    public T addArmor(Material material) {
        if (!material.has(MaterialTags.ARMOR)) {
            return (T)this;
        }
        ArmorData data = MaterialTags.ARMOR.get(material);
        return this.addArmor(data.armor(), data.toughness(), data.knockbackResistance(), data.armorDurabilityFactor());
    }

    public T addHandleStat(int durability, float speed) {
        return this.addHandleStat(durability, speed, (ImmutableMap<Enchantment, Integer>)ImmutableMap.of());
    }

    public T addHandleStat(int durability, float speed, ImmutableMap<Enchantment, Integer> toolEnchantment) {
        if (!this.has(GTMaterialTypes.ROD)) {
            this.flags(GTMaterialTypes.ROD);
        }
        MaterialTags.HANDLE.add(this.material, new HandleData(durability, speed, toolEnchantment));
        return (T)this;
    }

    public boolean has(IMaterialTag ... tags) {
        for (IMaterialTag t : tags) {
            if (t.all().contains(this.material)) continue;
            return false;
        }
        return true;
    }

    public T flags(IMaterialTag ... tags) {
        if (!this.material.enabled) {
            return (T)this;
        }
        for (IMaterialTag t : tags) {
            if (!this.has(t)) {
                t.add(this.material);
            }
            this.flags((IMaterialTag[])t.dependents().stream().filter(d -> !this.has((IMaterialTag)d)).toArray(IMaterialTag[]::new));
        }
        return (T)this;
    }

    public T setExpRange(UniformInt expRange) {
        MaterialTags.EXP_RANGE.add(this.material, expRange);
        return (T)this;
    }

    public T setExpRange(int min, int max) {
        return this.setExpRange(UniformInt.m_146622_((int)min, (int)max));
    }

    public void remove(IMaterialTag ... tags) {
        if (!this.material.enabled) {
            return;
        }
        for (IMaterialTag t : tags) {
            t.remove(this.material);
        }
    }

    public T mats(Function<ImmutableMap.Builder<Material, Integer>, ImmutableMap.Builder<Material, Integer>> func) {
        if (!this.material.enabled) {
            return (T)this;
        }
        return this.mats((ImmutableMap<Material, Integer>)func.apply((ImmutableMap.Builder<Material, Integer>)new ImmutableMap.Builder()).build());
    }

    public T mats(ImmutableMap<Material, Integer> stacks) {
        return this.mats(stacks, -1);
    }

    public T mats(ImmutableMap<Material, Integer> stacks, int inputAmount) {
        if (!this.material.enabled) {
            return (T)this;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        stacks.forEach((k, v) -> builder.add((Object)new MaterialStack((Material)k, (int)v)));
        MaterialTags.PROCESS_INTO.add(this.material, (Pair<List<MaterialStack>, Integer>)Pair.of((Object)builder.build(), (Object)inputAmount));
        return (T)this;
    }

    public T setOreMulti(int multi) {
        MaterialTags.ORE_MULTI.add(this.material, multi);
        return (T)this;
    }

    public T setSmeltingMulti(int multi) {
        MaterialTags.SMELTING_MULTI.add(this.material, multi);
        return (T)this;
    }

    public T setByProductMulti(int multi) {
        MaterialTags.BY_PRODUCT_MULTI.add(this.material, multi);
        return (T)this;
    }

    public T setSmeltInto(Material m) {
        MaterialTags.SMELT_INTO.add(this.material, m);
        return (T)this;
    }

    public T setDirectSmeltInto(Material m) {
        MaterialTags.DIRECT_SMELT_INTO.add(this.material, m);
        return (T)this;
    }

    public T setArcSmeltInto(Material m) {
        MaterialTags.ARC_SMELT_INTO.add(this.material, m);
        return (T)this;
    }

    public T setMacerateInto(Material m) {
        MaterialTags.MACERATE_INTO.add(this.material, m);
        return (T)this;
    }

    public T setMeltInto(Material m) {
        MaterialTags.MELT_INTO.add(this.material, m);
        if (this.material != m) {
            this.remove(GTMaterialTypes.LIQUID, MaterialTags.MOLTEN);
        }
        return (T)this;
    }

    public T addByProduct(Material ... mats) {
        MaterialTags.BYPRODUCTS.add(this.material, (Material)new ObjectArrayList());
        MaterialTags.BYPRODUCTS.getList(this.material).addAll(Arrays.asList(mats));
        return (T)this;
    }

    public T replaceItem(MaterialTypeItem<?> type, Item toReplace) {
        type.replacement(this.material, () -> toReplace);
        return (T)this;
    }

    public T replaceBlock(MaterialTypeBlock<?> type, Item toReplace) {
        type.replacement(this.material, () -> toReplace);
        return (T)this;
    }

    public T replaceItem(MaterialTypeItem<?> type, Supplier<Item> toReplace) {
        type.replacement(this.material, toReplace);
        return (T)this;
    }

    public T replaceBlock(MaterialTypeBlock<?> type, Supplier<Item> toReplace) {
        type.replacement(this.material, toReplace);
        return (T)this;
    }

    public ToolBuiler tool() {
        return new ToolBuiler();
    }

    public ToolBuiler tool(Material derivedMaterial) {
        ToolData data = MaterialTags.TOOLS.get(derivedMaterial);
        return this.tool().toolDamage(data.toolDamage()).toolDurability(data.toolDurability()).toolQuality(data.toolQuality()).toolSpeed(data.toolSpeed());
    }

    protected T buildTool(ToolData builder) {
        if (this.has(GTMaterialTypes.INGOT)) {
            this.flags(GTMaterialTypes.PLATE, GTMaterialTypes.ROD, GTMaterialTypes.SCREW, GTMaterialTypes.BOLT);
        } else {
            this.flags(GTMaterialTypes.ROD);
        }
        List<GTToolType> toolTypesList = builder.toolTypes();
        MaterialTags.TOOLS.add(this.material, builder);
        MaterialTags.MINING_LEVEL.add(this.material, builder.toolQuality() - 1);
        for (GTToolType type : toolTypesList) {
            if (type.getMaterialTypeItem() == null || this.material == Material.NULL || !type.getMaterialTypeItemPredicate().test(this.material)) continue;
            this.flags(type.getMaterialTypeItem());
        }
        return (T)this;
    }

    public class ToolBuiler {
        List<GTToolType> allowedToolTypes;
        float toolDamage;
        float toolSpeed;
        int toolDurability;
        int toolQuality;
        ImmutableMap<Enchantment, Integer> toolEnchantments = ImmutableMap.of();
        Material handleMaterial;

        public ToolBuiler() {
            this.allowedToolTypes = GTAPI.all(GTToolType.class);
            this.handleMaterial = GTLibMaterials.Wood;
        }

        public ToolBuiler blacklistToolTypes(GTToolType ... types) {
            this.allowedToolTypes.removeAll(List.of(types));
            return this;
        }

        public T build() {
            ArrayList<GTToolType> toolTypes = new ArrayList<GTToolType>(this.allowedToolTypes);
            for (GTToolType allowedToolType : this.allowedToolTypes) {
                if (allowedToolType.getPrimaryMaterialRequirement() == null || MaterialEvent.this.material.has(allowedToolType.getPrimaryMaterialRequirement())) continue;
                toolTypes.remove(allowedToolType);
            }
            if (toolTypes.contains(GTTools.WRENCH) && !toolTypes.contains(GTTools.WRENCH_ALT)) {
                toolTypes.add(GTTools.WRENCH_ALT);
            }
            this.allowedToolTypes = ImmutableList.copyOf(toolTypes);
            int toolDurability = GTAPI.isModLoaded("tfc") ? this.toolDurability * 4 : this.toolDurability;
            return MaterialEvent.this.buildTool(new ToolData(this.toolDamage, this.toolSpeed, toolDurability, this.toolQuality, this.handleMaterial, this.toolEnchantments, this.allowedToolTypes));
        }

        @Generated
        public ToolBuiler allowedToolTypes(List<GTToolType> allowedToolTypes) {
            this.allowedToolTypes = allowedToolTypes;
            return this;
        }

        @Generated
        public ToolBuiler toolDamage(float toolDamage) {
            this.toolDamage = toolDamage;
            return this;
        }

        @Generated
        public ToolBuiler toolSpeed(float toolSpeed) {
            this.toolSpeed = toolSpeed;
            return this;
        }

        @Generated
        public ToolBuiler toolDurability(int toolDurability) {
            this.toolDurability = toolDurability;
            return this;
        }

        @Generated
        public ToolBuiler toolQuality(int toolQuality) {
            this.toolQuality = toolQuality;
            return this;
        }

        @Generated
        public ToolBuiler toolEnchantments(ImmutableMap<Enchantment, Integer> toolEnchantments) {
            this.toolEnchantments = toolEnchantments;
            return this;
        }

        @Generated
        public ToolBuiler handleMaterial(Material handleMaterial) {
            this.handleMaterial = handleMaterial;
            return this;
        }
    }
}

