/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class GTTagBuilder<T> {
    public TagBuilder builder;
    public final ResourceKey<Registry<T>> registry;
    public final List<T> removeElements = new ArrayList<T>();
    private final String source;
    boolean replace = false;
    private final Function<T, ResourceKey<T>> keyExtractor;

    public GTTagBuilder(TagBuilder builder, ResourceKey<Registry<T>> registry, String string, @Nullable Function<T, ResourceKey<T>> keyExtractor) {
        this.builder = builder;
        this.registry = registry;
        this.source = string;
        this.keyExtractor = keyExtractor;
    }

    public GTTagBuilder<T> add(T item) {
        if (this.keyExtractor != null) {
            return this.add(this.keyExtractor.apply(item));
        }
        return this;
    }

    public GTTagBuilder<T> add(ResourceKey<T> key) {
        this.builder.m_215900_(key.m_135782_());
        return this;
    }

    public GTTagBuilder<T> add(TagEntry builderEntry) {
        this.builder.m_215902_(builderEntry);
        return this;
    }

    public GTTagBuilder<T> add(ResourceKey<T> ... resourceKeys) {
        for (ResourceKey<T> resourceKey : resourceKeys) {
            this.builder.m_215900_(resourceKey.m_135782_());
        }
        return this;
    }

    public GTTagBuilder<T> add(ResourceLocation ... ids) {
        for (ResourceLocation id : ids) {
            this.builder.m_215900_(id);
        }
        return this;
    }

    public GTTagBuilder<T> addOptional(ResourceLocation location) {
        this.builder.m_215905_(location);
        return this;
    }

    public GTTagBuilder<T> addTag(TagKey<T> tag) {
        this.builder.m_215907_(tag.f_203868_());
        return this;
    }

    public GTTagBuilder<T> addTag(ResourceLocation tag) {
        this.builder.m_215907_(tag);
        return this;
    }

    public GTTagBuilder<T> addOptionalTag(ResourceLocation location) {
        this.builder.m_215909_(location);
        return this;
    }

    @SafeVarargs
    public final GTTagBuilder<T> add(T ... toAdd) {
        if (this.keyExtractor != null) {
            Stream.of(toAdd).map(this.keyExtractor).forEach(key -> this.builder.m_215900_(key.m_135782_()));
        }
        return this;
    }

    @SafeVarargs
    public final GTTagBuilder<T> remove(T ... remove) {
        this.removeElements.addAll(Arrays.asList(remove));
        return this;
    }

    public GTTagBuilder<T> replace() {
        return this.replace(true);
    }

    public GTTagBuilder<T> replace(boolean value) {
        this.replace = value;
        return this;
    }

    public GTTagBuilder<T> addFromJson(JsonObject json, String source) {
        JsonArray array;
        if (json.get("replace").getAsBoolean()) {
            this.builder = new TagBuilder();
        }
        if (!(array = json.getAsJsonArray("values")).isEmpty()) {
            for (JsonElement element : array) {
                if (!element.isJsonPrimitive()) continue;
                String entry = element.getAsString();
                ResourceLocation id = new ResourceLocation(entry.replace("#", "").replace("?", ""));
                if (entry.startsWith("#")) {
                    if (entry.endsWith("?")) {
                        this.addOptionalTag(id);
                        continue;
                    }
                    this.addTag(id);
                    continue;
                }
                if (entry.endsWith("?")) {
                    this.addOptional(id);
                    continue;
                }
                this.add(id);
            }
        }
        return this;
    }

    public JsonObject serializeToJson() {
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (TagEntry entry : this.builder.m_215904_()) {
            jsonArray.add(entry.toString());
        }
        jsonObject.addProperty("replace", Boolean.valueOf(this.replace));
        jsonObject.add("values", (JsonElement)jsonArray);
        return jsonObject;
    }
}

