/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.json.models.JElement;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.datagen.json.JGTLibModel;
import org.gtreimagined.gtlib.datagen.json.JModel;
import org.joml.Vector3f;

public class GTModelBuilder<T extends GTModelBuilder<T>>
implements IModelLocation {
    protected JGTLibModel model = JGTLibModel.modelKeepElements();
    protected JTextures textures = null;
    protected String renderType = null;
    protected String renderTypeFast = null;
    protected List<JElement> elements = new ArrayList<JElement>();
    protected ResourceLocation customLoader = null;
    private final ResourceLocation location;

    public GTModelBuilder(ResourceLocation location) {
        this.location = location;
    }

    private T self() {
        return (T)this;
    }

    public T loader(ResourceLocation customLoader) {
        this.customLoader = customLoader;
        return this.self();
    }

    public T parent(ResourceLocation parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        this.model.parent(parent.toString());
        return this.self();
    }

    public T texture(String key, String texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        if (this.textures == null) {
            this.textures = new JTextures();
        }
        if (texture.charAt(0) == '#') {
            this.textures.var(key, texture);
            return this.self();
        }
        ResourceLocation asLoc = texture.contains(":") ? new ResourceLocation(texture) : new ResourceLocation(this.getLocation().m_135827_(), texture);
        return this.texture(key, asLoc);
    }

    public T texture(String key, ResourceLocation texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        if (this.textures == null) {
            this.textures = new JTextures();
        }
        this.textures.var(key, texture.toString());
        return this.self();
    }

    public T renderType(String renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        return this.renderType(new ResourceLocation(renderType));
    }

    public T renderType(String renderType, String renderTypeFast) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        Preconditions.checkNotNull((Object)renderTypeFast, (Object)"Render type for fast graphics must not be null");
        return this.renderType(new ResourceLocation(renderType), new ResourceLocation(renderTypeFast));
    }

    public T renderType(ResourceLocation renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        this.renderType = renderType.toString();
        this.renderTypeFast = null;
        return this.self();
    }

    public T renderType(ResourceLocation renderType, ResourceLocation renderTypeFast) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        Preconditions.checkNotNull((Object)renderTypeFast, (Object)"Render type for fast graphics must not be null");
        this.renderType = renderType.toString();
        this.renderTypeFast = renderTypeFast.toString();
        return this.self();
    }

    public T ao(boolean ao) {
        this.model.ambientOcclusion(ao);
        return this.self();
    }

    public JElement element() {
        Preconditions.checkState((this.customLoader == null ? 1 : 0) != 0, (Object)"Cannot use elements and custom loaders at the same time");
        JElement element = new JElement();
        this.elements.add(element);
        return element;
    }

    public JElement element(int index) {
        Preconditions.checkState((this.customLoader == null ? 1 : 0) != 0, (Object)"Cannot use elements and custom loaders at the same time");
        Preconditions.checkElementIndex((int)index, (int)this.elements.size(), (String)"Element index");
        return this.elements.get(index);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }

    private String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return new ResourceLocation(tex).toString();
    }

    private JsonArray serializeVector3f(Vector3f vec) {
        JsonArray ret = new JsonArray();
        ret.add(this.serializeFloat(vec.x()));
        ret.add(this.serializeFloat(vec.y()));
        ret.add(this.serializeFloat(vec.z()));
        return ret;
    }

    private Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }

    public JModel build() {
        if (this.textures != null) {
            this.model.textures(this.textures);
        }
        if (!this.elements.isEmpty()) {
            this.model.element(this.elements.toArray(new JElement[0]));
        }
        if (this.customLoader != null) {
            this.model.loader(this.customLoader.toString());
        }
        if (this.renderType != null) {
            this.model.renderType(this.renderType);
        }
        if (this.renderTypeFast != null) {
            this.model.renderTypeFast(this.renderTypeFast);
        }
        return this.model;
    }
}

