/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.pipe;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;

public class PipeCoverHandler<T extends BlockEntityPipe<?>>
extends CoverHandler<T> {
    public PipeCoverHandler(T tile) {
        super(tile, ((BlockEntityPipe)tile).getValidCovers());
    }

    @Override
    public boolean placeCover(Player player, Direction side, ItemStack stack, ICover cover) {
        ICover old = this.get(side);
        boolean ok = super.placeCover(player, side, stack, cover);
        if (ok) {
            boolean anyEmpty = this.covers.values().stream().anyMatch(ICover::isNode);
            ((BlockEntityPipe)this.getTile()).onCoverUpdate(false, anyEmpty, side, old, cover);
        }
        return ok;
    }

    @Override
    public boolean removeCover(Player player, Direction side, boolean onlyRemove) {
        ICover old = this.get(side);
        boolean ok = super.removeCover(player, side, onlyRemove);
        if (ok) {
            ICover stack = ICover.empty;
            boolean anyEmpty = this.covers.values().stream().anyMatch(ICover::isNode);
            ((BlockEntityPipe)this.getTile()).onCoverUpdate(true, anyEmpty, side, old, stack);
        }
        return ok;
    }

    @Override
    public void readFromStack(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("covers")) {
            CompoundTag nbt = stack.m_41783_().m_128469_("covers");
            byte sides = nbt.m_128445_("vs");
            for (int i = 0; i < Ref.DIRS.length; ++i) {
                if ((sides & 1 << i) <= 0) continue;
                ICover cover = CoverFactory.readCover(this, Direction.m_122376_((int)i), nbt, true);
                this.buildLookup(((ICover)this.covers.get((Object)Ref.DIRS[i])).getFactory(), cover.getFactory(), Ref.DIRS[i]);
                this.covers.put((Object)Ref.DIRS[i], (Object)cover);
                boolean anyEmpty = this.covers.values().stream().anyMatch(ICover::isNode);
                ((BlockEntityPipe)this.getTile()).onCoverUpdate(false, anyEmpty, Ref.DIRS[i], ICover.empty, cover);
            }
        }
    }

    @Override
    public void writeToStack(ItemStack machine) {
        CompoundTag tag = new CompoundTag();
        byte[] sides = new byte[1];
        this.covers.forEach((s, cover) -> {
            if (!cover.isEmpty()) {
                sides[0] = (byte)(sides[0] | 1 << s.m_122411_());
                CoverFactory.writeCover(tag, cover, cover.side(), true);
            }
        });
        if (!tag.m_128456_()) {
            tag.m_128344_("vs", sides[0]);
            machine.m_41784_().m_128365_("covers", (Tag)tag);
        }
    }
}

