/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib;

import com.terraformersmc.terraform.utils.TerraformFuelRegistry;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.devtech.arrp.ARRP;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.GTMod;
import org.gtreimagined.gtlib.block.BlockDimensionMarker;
import org.gtreimagined.gtlib.client.ClientData;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.common.event.ARRPEvents;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTLibBlocks;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.GTLoot;
import org.gtreimagined.gtlib.datagen.loaders.MaterialRecipes;
import org.gtreimagined.gtlib.datagen.loaders.StoneRecipes;
import org.gtreimagined.gtlib.datagen.providers.GTBlockLootProvider;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTFluidTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTLanguageProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.event.GTCraftingEvent;
import org.gtreimagined.gtlib.event.GTProvidersEvent;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.integration.Integrations;
import org.gtreimagined.gtlib.integration.kubejs.KubeJSRegistrar;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.item.interaction.CauldronInteractions;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.material.SubTag;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.proxy.ClientHandler;
import org.gtreimagined.gtlib.proxy.CommonHandler;
import org.gtreimagined.gtlib.proxy.IProxyHandler;
import org.gtreimagined.gtlib.proxy.ServerHandler;
import org.gtreimagined.gtlib.recipe.Recipe;
import org.gtreimagined.gtlib.recipe.RecipeBuilders;
import org.gtreimagined.gtlib.recipe.container.MirroredShapedRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.IngredientSerializer;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialSerializer;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.worldgen.GTLibWorldGenerator;
import org.gtreimagined.gtlib.worldgen.bedrockore.BedrockVeinData;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOreData;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerData;
import org.gtreimagined.gtlib.worldgen.vanillaore.VanillaVeinData;
import org.gtreimagined.gtlib.worldgen.vein.VeinData;

@Mod(value="gtlib")
public class GTLib
extends GTMod {
    public static GTLib INSTANCE;
    public static final Logger LOGGER;
    public static IProxyHandler PROXY;

    public GTLib() {
        LOGGER.info("Loading GTLib");
        INSTANCE = this;
        PROXY = (IProxyHandler)DistExecutor.unsafeRunForDist(() -> ClientHandler::new, () -> ServerHandler::new);
        if (GTAPI.isModLoaded("kubejs")) {
            new KubeJSRegistrar();
        }
        GTLibDynamics.clientProvider("gtlib", () -> new GTBlockStateProvider("gtlib", "GTLib".concat(" BlockStates")));
        GTLibDynamics.clientProvider("gtlib", () -> new GTItemModelProvider("gtlib", "GTLib".concat(" Item Models")));
        GTLibDynamics.clientProvider("gt", () -> new GTBlockStateProvider("gt", "GT Shared BlockStates"));
        GTLibDynamics.clientProvider("gt", () -> new GTItemModelProvider("gt", "GT Shared Item Models"));
        GTLibDynamics.clientProvider("gtlib", () -> new GTLanguageProvider("gtlib", "GTLib".concat(" en_us Localization"), "en_us"));
        GTLibDynamics.clientProvider("gt", () -> new GTLanguageProvider("gt", "GTLib".concat(" en_us Localization (Shared)"), "en_us"));
        GTAPI.init();
        GTLibNetwork.register();
        GTLibConfig.createConfig();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::serverSetup);
        eventBus.addListener(this::loadComplete);
        eventBus.addListener(this::addCraftingLoaders);
        eventBus.addListener(this::providers);
        MinecraftForge.EVENT_BUS.addListener(this::onServerReloadListeners);
        ARRP.EVENT_BUS.register(ARRPEvents.class);
    }

    public void onServerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)VanillaVeinData.INSTANCE);
        event.addListener((PreparableReloadListener)VeinData.INSTANCE);
        event.addListener((PreparableReloadListener)SmallOreData.INSTANCE);
        event.addListener((PreparableReloadListener)BedrockVeinData.INSTANCE);
        event.addListener((PreparableReloadListener)StoneLayerData.INSTANCE);
    }

    public void addCraftingLoaders(GTCraftingEvent ev) {
        ev.addLoader(StoneRecipes::loadRecipes);
        ev.addLoader(MaterialRecipes::init);
    }

    public void providers(GTProvidersEvent ev) {
        GTBlockTagProvider[] p = new GTBlockTagProvider[1];
        ev.addProvider(() -> {
            p[0] = new GTBlockTagProvider("gtlib", "GTLib".concat(" Block Tags"), false);
            return p[0];
        });
        ev.addProvider(() -> new GTFluidTagProvider("gt", "GT Shared Fluid Tags", false));
        ev.addProvider(() -> new GTItemTagProvider("gtlib", "GTLib".concat(" Item Tags"), false, p[0]));
        ev.addProvider(() -> new GTBlockLootProvider("gtlib", "GTLib".concat(" Loot generator")));
        ev.addProvider(() -> new GTTagProvider<Biome>(Registries.f_256952_, "gtlib", "GTLib".concat(" Biome Tags"), "worldgen/biome", null){

            @Override
            protected void processTags(String domain) {
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_desert"))).add((ResourceKey<Biome>)Biomes.f_48203_);
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_plains"))).add((ResourceKey<Biome>)Biomes.f_48202_);
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_savanna"))).add(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_);
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_swamp"))).add((ResourceKey<Biome>)Biomes.f_48207_);
            }
        });
        if (GTAPI.isModLoaded("kubejs")) {
            KubeJSRegistrar.providerEvent(ev);
        }
    }

    @Override
    public void onRegistrationEvent(RegistrationEvent event, Dist side) {
        if (event == RegistrationEvent.DATA_INIT) {
            Recipe.init();
            GTLoot.RandomWeightLootFunction.init();
            SlotType.init();
            RecipeBuilders.init();
            MachineState.init();
            GTLibMaterials.init();
            GTMaterialTypes.init();
            GTTools.init(side);
            VanillaStoneTypes.init();
            GTLibBlocks.init();
            Data.init(side);
            ICover.init();
            SubTag.init();
            GTLibWorldGenerator.preinit();
            GuiEvents.init();
            MaterialSerializer.init();
            MirroredShapedRecipe.init();
            MachineRecipeSerializer.init();
            IngredientSerializer.init();
            PropertyIngredient.Serializer.init();
        } else if (event == RegistrationEvent.WORLDGEN_INIT) {
            GTLibWorldGenerator.init();
            GTTools.postInit();
        } else if (event == RegistrationEvent.DATA_READY) {
            CauldronInteractions.init();
            if (GTAPI.isModLoaded("jei") || GTAPI.isModLoaded("roughlyenoughitems")) {
                GTLibXEIPlugin.registerMissingMaps();
            }
            GTLibXEIPlugin.addItemsToHide(l -> {
                if (!GTLibConfig.SHOW_ALL_ORES.get()) {
                    GTAPI.all(StoneType.class, s -> {
                        if (s != VanillaStoneTypes.STONE && s != VanillaStoneTypes.SAND && s.doesGenerateOre()) {
                            GTMaterialTypes.ORE.all().forEach(m -> {
                                Block ore = ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get((Material)m, (StoneType)s).asBlock();
                                if (ore instanceof BlockOre) {
                                    l.add(ore);
                                }
                            });
                            GTMaterialTypes.SMALL_ORE.all().forEach(m -> {
                                Block ore = ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.SMALL_ORE.get()).get((Material)m, (StoneType)s).asBlock();
                                if (ore instanceof BlockOre) {
                                    l.add(ore);
                                }
                            });
                        }
                    });
                }
                GTAPI.all(MaterialTypeItem.class, t -> {
                    if (!t.hidden()) {
                        return;
                    }
                    List stacks = t.all().stream().map(obj -> t.get((Material)obj)).collect(Collectors.toList());
                    if (stacks.isEmpty()) {
                        return;
                    }
                    l.addAll(stacks);
                });
                GTAPI.all(IGTTool.class).stream().filter(t -> t.getGTToolType() == GTTools.WRENCH_ALT).forEach(tool -> l.add(tool.getItem()));
                GTAPI.all(GTFluid.class).forEach(t -> l.add(t.getFluidBlock()));
                GTAPI.all(BlockDimensionMarker.class).forEach(b -> l.add(b.m_5456_()));
            });
            GTAPI.all(Material.class).forEach(m -> {
                Map<MaterialType<?>, Integer> map = MaterialTags.FURNACE_FUELS.getMap((Material)m);
                if (map != null) {
                    map.forEach((t, i) -> {
                        MaterialTypeBlock typeBlock;
                        Object patt12204$temp;
                        if (t instanceof MaterialTypeItem) {
                            MaterialTypeItem typeItem = (MaterialTypeItem)t;
                            TerraformFuelRegistry.addFuel((Item)typeItem.get((Material)m), (int)i);
                        } else if (t instanceof MaterialTypeBlock && (patt12204$temp = (typeBlock = (MaterialTypeBlock)t).get()) instanceof MaterialTypeBlock.IBlockGetter) {
                            MaterialTypeBlock.IBlockGetter blockGetter = (MaterialTypeBlock.IBlockGetter)patt12204$temp;
                            TerraformFuelRegistry.addFuel((Item)blockGetter.get((Material)m).asItem(), (int)i);
                        }
                    });
                }
            });
        } else if (event == RegistrationEvent.CLIENT_DATA_INIT) {
            GTLibModelManager.init();
            ClientData.init();
        }
    }

    public static BufferedImage readImage(String imagePath) throws IOException {
        InputStream in = GTLib.class.getResourceAsStream("/assets/gtlib/textures/" + imagePath + ".png");
        return ImageIO.read(in);
    }

    @Override
    public String getId() {
        return "gtlib";
    }

    private void clientSetup(FMLClientSetupEvent e) {
        ClientHandler.setup();
        GTAPI.onRegistration(RegistrationEvent.DATA_READY);
        GTLibDynamics.runDataProvidersDynamically();
        e.enqueueWork(() -> GTAPI.getClientDeferredQueue().ifPresent(t -> {
            for (Runnable r : t) {
                try {
                    r.run();
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught error during client setup: " + ex.getMessage());
                }
            }
        }));
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        CommonHandler.setup();
        GTLibDynamics.setInitialized();
        LOGGER.info("GTLib Data Processing has Finished. All Data Objects can now be Modified!");
        e.enqueueWork(() -> GTAPI.getCommonDeferredQueue().ifPresent(t -> {
            for (Runnable r : t) {
                try {
                    r.run();
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught error during common setup: " + ex.getMessage());
                }
            }
        }));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(Integrations::enqueueIMC);
    }

    private void serverSetup(FMLDedicatedServerSetupEvent e) {
        ServerHandler.setup();
        GTAPI.onRegistration(RegistrationEvent.DATA_READY);
        GTLibDynamics.runDataProvidersDynamically();
        e.enqueueWork(() -> GTAPI.getServerDeferredQueue().ifPresent(t -> {
            for (Runnable r : t) {
                try {
                    r.run();
                }
                catch (Exception ex) {
                    LOGGER.warn("Caught error during server setup: " + ex.getMessage());
                }
            }
        }));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
    }

    static {
        LOGGER = LogManager.getLogger((String)"gtlib");
    }
}

