package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

;
;

public class BackgroundWidget extends Widget {

    private final int xSize, ySize, guiXSize, guiYSize;
    private final ResourceLocation loc;

    protected BackgroundWidget(GuiInstance instance, IGuiElement parent, ResourceLocation loc, int xSize, int ySize, int guiXSize, int guiYSize) {
        super(instance, parent);
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.loc = loc;
        setDepth(-2);
    }

    @Override
    public void setParent(IGuiElement parent) {
        super.setParent(parent);
        this.setDepth(parent.depth() - 1);
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h) {
        return builder((a, b) -> new BackgroundWidget(a, b, loc, w, h, 256, 256)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h, int guiW, int guiH) {
        return builder((a, b) -> new BackgroundWidget(a, b, loc, w, h, guiW, guiH)).clientSide();
    }


    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        drawTexture(graphics, loc, realX(), realY(), 0, 0, xSize, ySize);
    }

    @OnlyIn(Dist.CLIENT)
    @Override
    protected void drawTexture(GuiGraphics graphics, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        //RenderSystem.setShaderColor(1, 1, 1, 1);
        //RenderSystem.setShader(GameRenderer::getPositionTexShader);
        //RenderSystem.setShaderTexture(0, loc);
        //AbstractGui.blit(stack, left, top, x, y, sizeX, sizeY);
        graphics.blit(loc, left, top, x, y, sizeX, sizeY, this.guiXSize, this.guiYSize);
    }
}
