/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.armor;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTCreativeTabs;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.tool.IGTArmor;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.gtreimagined.gtlib.tool.armor.MatArmorMaterial;
import org.jetbrains.annotations.Nullable;

public class MaterialArmor
extends ArmorItem
implements IGTArmor,
DyeableLeatherItem {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected String domain;
    protected GTArmorType type;
    protected Material material;

    public MaterialArmor(String domain, GTArmorType type, Material materialIn, ArmorItem.Type armorType, Item.Properties builderIn) {
        super((ArmorMaterial)new MatArmorMaterial(type, materialIn), armorType, builderIn);
        this.domain = domain;
        this.material = materialIn;
        this.type = type;
        GTAPI.register(IGTArmor.class, this);
        if (type.getArmorType() == ArmorItem.Type.HELMET && FMLEnvironment.dist.isClient()) {
            RenderHelper.registerProbePropertyOverrides(this);
        }
    }

    @Override
    public String getId() {
        return this.material.getId() + "_" + this.type.getId();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public GTArmorType getGTArmorType() {
        return this.type;
    }

    @Override
    public Material getMat() {
        return this.material;
    }

    @Override
    public ItemStack asItemStack() {
        return new ItemStack((ItemLike)this);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return amount;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.m_41462_();
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        Map<Enchantment, Integer> enchants = this.getAllEnchantments(stack);
        if (enchants.containsKey(enchantment)) {
            return enchants.get(enchantment);
        }
        return 0;
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.ARMOR.get(this.getMat()).toolEnchantment();
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> enchants.put((Enchantment)e.getKey(), (Integer)e.getValue()));
        }
        return enchants;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
        this.appendEnchantmentNames(tooltip, this.getAllEnchantments(stack));
    }

    @Override
    public void fillItemCategory(ResourceKey<CreativeModeTab> category, NonNullList<ItemStack> items) {
        if (category != GTCreativeTabs.TOOLS.getKey()) {
            return;
        }
        items.add((Object)this.asItemStack());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag nbt;
        String extra = "";
        if (slot == EquipmentSlot.HEAD && type != null && (nbt = stack.m_41783_()) != null && nbt.m_128441_("theoneprobe") && nbt.m_128471_("theoneprobe")) {
            extra = "_probe";
        }
        return "gtlib:textures/models/armor_layer_" + (slot == EquipmentSlot.LEGS ? 2 : 1) + (String)(type == null ? "" : "_" + type + extra) + ".png";
    }

    public int m_41121_(ItemStack stack) {
        return this.getItemColor(stack, null, 0);
    }

    public boolean m_41113_(ItemStack stack) {
        return this.material != Material.NULL;
    }

    public void m_41115_(ItemStack stack, int color) {
    }

    public void m_41123_(ItemStack stack) {
    }
}

